/*
 * Decompiled with CFR 0.152.
 */
package com.github.greengerong;

import com.github.greengerong.PreRenderEventHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrerenderConfig {
    private static final Logger log = LoggerFactory.getLogger(PrerenderConfig.class);
    private Map<String, String> config;

    public PrerenderConfig(Map<String, String> config) {
        this.config = config;
    }

    public PreRenderEventHandler getEventHandler() {
        String preRenderEventHandler = this.config.get("preRenderEventHandler");
        if (StringUtils.isNotBlank((String)preRenderEventHandler)) {
            try {
                return (PreRenderEventHandler)Class.forName(preRenderEventHandler).newInstance();
            }
            catch (Exception e) {
                log.error("PreRenderEventHandler class not find or can not new a instance", (Throwable)e);
            }
        }
        return null;
    }

    public CloseableHttpClient getHttpClient() {
        HttpClientBuilder builder = HttpClients.custom();
        builder = this.configureProxy(builder);
        builder = this.configureTimeout(builder);
        builder = builder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager());
        return builder.build();
    }

    private HttpClientBuilder configureProxy(HttpClientBuilder builder) {
        String proxy = this.config.get("proxy");
        if (StringUtils.isNotBlank((String)proxy)) {
            int proxyPort = Integer.parseInt(this.config.get("proxyPort"));
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(new HttpHost(proxy, proxyPort));
            builder = builder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        return builder;
    }

    private HttpClientBuilder configureTimeout(HttpClientBuilder builder) {
        String socketTimeout = this.getSocketTimeout();
        if (socketTimeout != null) {
            RequestConfig config = RequestConfig.custom().setSocketTimeout(Integer.parseInt(socketTimeout)).build();
            builder = builder.setDefaultRequestConfig(config);
        }
        return builder;
    }

    public String getSocketTimeout() {
        return this.config.get("socketTimeout");
    }

    public String getPrerenderToken() {
        return this.config.get("prerenderToken");
    }

    public String getForwardedURLHeader() {
        return this.config.get("forwardedURLHeader");
    }

    public List<String> getCrawlerUserAgents() {
        ArrayList crawlerUserAgents = Lists.newArrayList((Object[])new String[]{"googlebot", "yahoo", "bingbot", "baiduspider", "facebookexternalhit", "twitterbot", "rogerbot", "linkedinbot", "embedly"});
        String crawlerUserAgentsFromConfig = this.config.get("crawlerUserAgents");
        if (StringUtils.isNotBlank((String)crawlerUserAgentsFromConfig)) {
            crawlerUserAgents.addAll(Arrays.asList(crawlerUserAgentsFromConfig.trim().split(",")));
        }
        return crawlerUserAgents;
    }

    public List<String> getExtensionsToIgnore() {
        ArrayList extensionsToIgnore = Lists.newArrayList((Object[])new String[]{".xml", ".js", ".css", ".less", ".png", ".jpg", ".jpeg", ".gif", ".pdf", ".doc", ".txt", ".zip", ".mp3", ".rar", ".exe", ".wmv", ".doc", ".avi", ".ppt", ".mpg", ".mpeg", ".tif", ".wav", ".mov", ".psd", ".ai", ".xls", ".mp4", ".m4a", ".swf", ".dat", ".dmg", ".iso", ".flv", ".m4v", ".torrent"});
        String extensionsToIgnoreFromConfig = this.config.get("extensionsToIgnore");
        if (StringUtils.isNotBlank((String)extensionsToIgnoreFromConfig)) {
            extensionsToIgnore.addAll(Arrays.asList(extensionsToIgnoreFromConfig.trim().split(",")));
        }
        return extensionsToIgnore;
    }

    public List<String> getWhitelist() {
        String whitelist = this.config.get("whitelist");
        if (StringUtils.isNotBlank((String)whitelist)) {
            return Arrays.asList(whitelist.trim().split(","));
        }
        return null;
    }

    public List<String> getBlacklist() {
        String blacklist = this.config.get("blacklist");
        if (StringUtils.isNotBlank((String)blacklist)) {
            return Arrays.asList(blacklist.trim().split(","));
        }
        return null;
    }

    public String getPrerenderServiceUrl() {
        String prerenderServiceUrl = this.config.get("prerenderServiceUrl");
        return StringUtils.isNotBlank((String)prerenderServiceUrl) ? prerenderServiceUrl : "http://service.prerender.io/";
    }
}

