/*
 * Decompiled with CFR 0.152.
 */
package com.github.greengerong;

import com.github.greengerong.PreRenderEventHandler;
import com.github.greengerong.PrerenderConfig;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrerenderSeoService {
    public static final int HTTP_OK = 200;
    private static final Logger log;
    private static final HeaderGroup hopByHopHeaders;
    private CloseableHttpClient httpClient;
    private PrerenderConfig prerenderConfig;
    private PreRenderEventHandler preRenderEventHandler;

    public PrerenderSeoService(Map<String, String> config) {
        this.prerenderConfig = new PrerenderConfig(config);
        this.httpClient = this.getHttpClient();
    }

    public void destroy() {
        if (this.preRenderEventHandler != null) {
            this.preRenderEventHandler.destroy();
        }
        this.closeQuietly((Closeable)this.httpClient);
    }

    public boolean prerenderIfEligible(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        try {
            if (this.handlePrerender(servletRequest, servletResponse)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("Prerender service error", (Throwable)e);
        }
        return false;
    }

    private boolean handlePrerender(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws URISyntaxException, IOException {
        if (this.shouldShowPrerenderedPage(servletRequest)) {
            this.preRenderEventHandler = this.prerenderConfig.getEventHandler();
            if (this.beforeRender(servletRequest, servletResponse) || this.proxyPrerenderedPageResponse(servletRequest, servletResponse)) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldShowPrerenderedPage(HttpServletRequest request) throws URISyntaxException {
        String userAgent = request.getHeader("User-Agent");
        String url = this.getRequestURL(request);
        String referer = request.getHeader("Referer");
        log.trace("checking request for " + url + " from User-Agent " + userAgent + " and referer " + referer);
        if (!"GET".equals(request.getMethod())) {
            log.trace("Request is not HTTP GET; intercept: no");
            return false;
        }
        if (this.isInResources(url)) {
            log.trace("request is for a (static) resource; intercept: no");
            return false;
        }
        List<String> whiteList = this.prerenderConfig.getWhitelist();
        if (whiteList != null && !this.isInWhiteList(url, whiteList)) {
            log.trace("Whitelist is enabled, but this request is not listed; intercept: no");
            return false;
        }
        List<String> blacklist = this.prerenderConfig.getBlacklist();
        if (blacklist != null && this.isInBlackList(url, referer, blacklist)) {
            log.trace("Blacklist is enabled, and this request is listed; intercept: no");
            return false;
        }
        if (this.hasEscapedFragment(request)) {
            log.trace("Request Has _escaped_fragment_; intercept: yes");
            return true;
        }
        if (StringUtils.isBlank((String)userAgent)) {
            log.trace("Request has blank userAgent; intercept: no");
            return false;
        }
        if (!this.isInSearchUserAgent(userAgent)) {
            log.trace("Request User-Agent is not a search bot; intercept: no");
            return false;
        }
        log.trace(String.format("Defaulting to request intercept(user-agent=%s): yes", userAgent));
        return true;
    }

    protected HttpGet getHttpGet(String apiUrl) {
        return new HttpGet(apiUrl);
    }

    protected CloseableHttpClient getHttpClient() {
        return this.prerenderConfig.getHttpClient();
    }

    private void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) throws URISyntaxException {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    HttpHost host = URIUtils.extractHost((URI)new URI(this.prerenderConfig.getPrerenderServiceUrl()));
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    private String getRequestURL(HttpServletRequest request) {
        String url;
        if (this.prerenderConfig.getForwardedURLHeader() != null && (url = request.getHeader(this.prerenderConfig.getForwardedURLHeader())) != null) {
            return url;
        }
        return request.getRequestURL().toString();
    }

    private String getApiUrl(String url) {
        String prerenderServiceUrl = this.prerenderConfig.getPrerenderServiceUrl();
        if (!prerenderServiceUrl.endsWith("/")) {
            prerenderServiceUrl = prerenderServiceUrl + "/";
        }
        return prerenderServiceUrl + url;
    }

    private void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            PrintWriter printWriter = servletResponse.getWriter();
            try {
                String html = EntityUtils.toString((HttpEntity)entity);
                printWriter.write(html);
                printWriter.flush();
                String string = html;
                return string;
            }
            finally {
                this.closeQuietly(printWriter);
            }
        }
        return "";
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            log.error("Close proxy error", (Throwable)e);
        }
    }

    private boolean hasEscapedFragment(HttpServletRequest request) {
        return request.getParameterMap().containsKey("_escaped_fragment_");
    }

    private boolean isInBlackList(final String url, final String referer, List<String> blacklist) {
        return FluentIterable.from(blacklist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                Pattern pattern = Pattern.compile(regex);
                return pattern.matcher(url).matches() || !StringUtils.isBlank((String)referer) && pattern.matcher(referer).matches();
            }
        });
    }

    private boolean isInSearchUserAgent(final String userAgent) {
        return FluentIterable.from(this.prerenderConfig.getCrawlerUserAgents()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return userAgent.toLowerCase().contains(item.toLowerCase());
            }
        });
    }

    private boolean isInResources(final String url) {
        return FluentIterable.from(this.prerenderConfig.getExtensionsToIgnore()).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return (url.indexOf(63) >= 0 ? url.substring(0, url.indexOf(63)) : url).toLowerCase().endsWith(item);
            }
        });
    }

    private boolean isInWhiteList(final String url, List<String> whitelist) {
        return FluentIterable.from(whitelist).anyMatch((Predicate)new Predicate<String>(){

            public boolean apply(String regex) {
                return Pattern.compile(regex).matcher(url).matches();
            }
        });
    }

    private boolean beforeRender(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String html;
        if (this.preRenderEventHandler != null && StringUtils.isNotBlank((String)(html = this.preRenderEventHandler.beforeRender(request)))) {
            PrintWriter writer = response.getWriter();
            writer.write(html);
            writer.flush();
            this.closeQuietly(writer);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean proxyPrerenderedPageResponse(HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        String apiUrl = this.getApiUrl(this.getFullUrl(request));
        log.trace(String.format("Prerender proxy will send request to:%s", apiUrl));
        HttpGet getMethod = this.getHttpGet(apiUrl);
        this.copyRequestHeaders(request, (HttpRequest)getMethod);
        this.withPrerenderToken((HttpRequest)getMethod);
        CloseableHttpResponse proxyResponse = null;
        try {
            proxyResponse = this.httpClient.execute((HttpUriRequest)getMethod);
            response.setStatus(proxyResponse.getStatusLine().getStatusCode());
            this.copyResponseHeaders((HttpResponse)proxyResponse, response);
            String html = this.copyResponseEntity((HttpResponse)proxyResponse, response);
            this.afterRender(request, proxyResponse, html);
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeQuietly((Closeable)proxyResponse);
        }
    }

    private void afterRender(HttpServletRequest request, CloseableHttpResponse proxyResponse, String html) {
        if (this.preRenderEventHandler != null) {
            this.preRenderEventHandler.afterRender(request, (HttpResponse)proxyResponse, html);
        }
    }

    private void withPrerenderToken(HttpRequest proxyRequest) {
        String token = this.prerenderConfig.getPrerenderToken();
        if (StringUtils.isNotBlank((String)token)) {
            proxyRequest.addHeader("X-Prerender-Token", token);
        }
    }

    private String getFullUrl(HttpServletRequest request) {
        String url = this.getRequestURL(request);
        String queryString = request.getQueryString();
        if (queryString != null) {
            return url + '?' + queryString;
        }
        return url;
    }

    static {
        String[] headers;
        log = LoggerFactory.getLogger(PrerenderSeoService.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

