/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.Demuxer;
import com.github.hoary.javaav.Image;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaFrame;
import com.github.hoary.javaav.VideoFrame;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;

public class Camera {
    private final AtomicBoolean open = new AtomicBoolean(false);
    private Demuxer demuxer;
    private String device;
    private String format;

    public Camera(String device, String source) {
        this.device = device;
        this.format = source;
    }

    public String getName() {
        return this.device;
    }

    public BufferedImage getImage() throws JavaAVException {
        MediaFrame mediaFrame;
        if (this.open.get() && (mediaFrame = this.demuxer.readFrame()).getType() == MediaFrame.Type.VIDEO) {
            VideoFrame videoFrame = (VideoFrame)mediaFrame;
            BufferedImage image = Image.createImage(videoFrame, 5);
            return image;
        }
        return null;
    }

    public void open(int width, int height, double frameRate) throws JavaAVException {
        if (!this.open.get()) {
            String input = "video=" + this.device;
            this.demuxer = new Demuxer();
            this.demuxer.setInputFormat(this.format);
            this.demuxer.setImageWidth(width);
            this.demuxer.setImageHeight(height);
            this.demuxer.setFramerate(frameRate);
            this.demuxer.open(input);
            this.open.set(true);
        }
    }

    public void close() {
        if (this.open.compareAndSet(true, false) && this.demuxer != null) {
            this.demuxer.close();
        }
    }

    public boolean isOpen() {
        return this.open.get();
    }
}

