/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFormat;
import com.github.hoary.javaav.AudioFrame;
import com.github.hoary.javaav.AudioResampler;
import com.github.hoary.javaav.ChannelLayout;
import com.github.hoary.javaav.Codec;
import com.github.hoary.javaav.CodecCapability;
import com.github.hoary.javaav.CodecID;
import com.github.hoary.javaav.Coder;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaPacket;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.PictureFormat;
import com.github.hoary.javaav.PictureResampler;
import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.SampleFormat;
import com.github.hoary.javaav.VideoFrame;
import com.googlecode.javacpp.BytePointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avutil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder
extends Coder {
    private static final Logger LOGGER = LogManager.getLogger((String)Encoder.class.getName());
    private BytePointer audioBuffer;
    private BytePointer videoBuffer;
    private int audioBufferSize;
    private int videoBufferSize;
    private PictureFormat dstVideoFormat;
    private AudioFormat audioFormat;
    private avcodec.AVPicture picture;
    private BytePointer pictureBuffer;
    private AudioResampler audioResampler;
    private PictureResampler videoResampler;
    private long sync_opts;

    public Encoder(CodecID codecId) throws JavaAVException {
        this(Codec.getEncoderById(codecId), null);
    }

    public Encoder(Codec codec) throws JavaAVException {
        this(codec, null);
    }

    Encoder(Codec codec, avcodec.AVCodecContext avContext) throws JavaAVException {
        super(codec, avContext);
        if (this.avContext != null) {
            this.avContext.codec_id(codec.getCodec().id());
        }
    }

    @Override
    public void open(Map<String, String> options) throws JavaAVException {
        super.open(options);
        if (this.codec.hasCapability(CodecCapability.EXPERIMENTAL)) {
            this.avContext.strict_std_compliance(-2);
        }
        if (this.getMediaType() == MediaType.VIDEO) {
            this.avFrame.pts(0L);
            this.createVideoBuffer();
            this.dstVideoFormat = new PictureFormat(this.avContext.width(), this.avContext.height(), PixelFormat.byId(this.avContext.pix_fmt()));
        } else if (this.getMediaType() == MediaType.AUDIO) {
            this.audioFormat = new AudioFormat();
            this.audioFormat.setSampleFormat(SampleFormat.byId(this.avContext.sample_fmt()));
            this.audioFormat.setChannelLayout(ChannelLayout.byId(this.avContext.channel_layout()));
            this.audioFormat.setChannels(this.avContext.channels());
            this.audioFormat.setSampleRate(this.avContext.sample_rate());
            this.audioBufferSize = 0x100000;
            this.audioBuffer = new BytePointer(avutil.av_malloc((long)this.audioBufferSize));
        }
        this.state = Coder.State.Opened;
    }

    @Override
    public void close() {
        if (this.pictureBuffer != null) {
            avutil.av_free((Pointer)this.pictureBuffer);
            this.pictureBuffer = null;
        }
        if (this.videoBuffer != null) {
            avutil.av_free((Pointer)this.videoBuffer);
            this.videoBuffer = null;
        }
        if (this.videoResampler != null) {
            this.videoResampler.close();
            this.videoResampler = null;
        }
        if (this.audioResampler != null) {
            this.audioResampler.close();
            this.audioResampler = null;
        }
        super.close();
    }

    public MediaPacket encodeVideo(VideoFrame frame) throws JavaAVException {
        ByteBuffer imageBuffer = null;
        if (frame != null) {
            imageBuffer = frame.getData();
            int width = frame.getWidth();
            int height = frame.getHeight();
            int step = imageBuffer.capacity() / (width * height) * width;
            int pixelFormat = frame.getPixelFormat().value();
            BytePointer data = new BytePointer(imageBuffer);
            PictureFormat srcVideoFormat = frame.getPictureFormat();
            if (!srcVideoFormat.equals(this.dstVideoFormat)) {
                if (this.videoResampler == null) {
                    this.videoResampler = new PictureResampler();
                }
                this.videoResampler.open(srcVideoFormat, this.dstVideoFormat);
                int codecWidth = this.avContext.width();
                int codecHeight = this.avContext.height();
                avcodec.avpicture_fill((avcodec.AVPicture)this.picture, (BytePointer)data, (int)pixelFormat, (int)width, (int)height);
                avcodec.avpicture_fill((avcodec.AVPicture)new avcodec.AVPicture((Pointer)this.avFrame), (BytePointer)this.pictureBuffer, (int)this.avContext.pix_fmt(), (int)codecWidth, (int)codecHeight);
                this.videoResampler.resample(this.picture, new avcodec.AVPicture((Pointer)this.avFrame));
            } else {
                avcodec.avpicture_fill((avcodec.AVPicture)new avcodec.AVPicture((Pointer)this.avFrame), (BytePointer)data, (int)pixelFormat, (int)width, (int)height);
                this.avFrame.linesize(0, step);
            }
        }
        avcodec.av_init_packet((avcodec.AVPacket)this.avPacket);
        this.avPacket.data(this.videoBuffer);
        this.avPacket.size(this.videoBufferSize);
        this.avFrame.pts(this.sync_opts);
        if (this.avFrame.interlaced_frame() != 0) {
            if (this.avContext.codec().id() == 8) {
                this.avContext.field_order(this.avFrame.top_field_first() != 0 ? 2 : 3);
            } else {
                this.avContext.field_order(this.avFrame.top_field_first() != 0 ? 4 : 5);
            }
        } else {
            this.avContext.field_order(1);
        }
        this.avFrame.quality(this.avContext.global_quality());
        if (this.avContext.me_threshold() == 0) {
            this.avFrame.pict_type(0);
        }
        if (avcodec.avcodec_encode_video2((avcodec.AVCodecContext)this.avContext, (avcodec.AVPacket)this.avPacket, (avutil.AVFrame)(imageBuffer == null ? null : this.avFrame), (int[])this.gotFrame) < 0) {
            throw new JavaAVException("Could not encode video packet.");
        }
        if (this.gotFrame[0] != 0) {
            if (this.avPacket.pts() == avutil.AV_NOPTS_VALUE && (this.avContext.codec().capabilities() & 0x20) == 0) {
                this.avPacket.pts(this.sync_opts);
            }
            MediaPacket mediaPacket = new MediaPacket(this.avPacket);
            mediaPacket.setKeyFrame(this.avFrame.key_frame() != 0);
            ++this.sync_opts;
            return mediaPacket;
        }
        ++this.sync_opts;
        return null;
    }

    public MediaPacket[] encodeAudio(AudioFrame audioFrame) throws JavaAVException {
        AudioFrame[] frames;
        if (this.audioFormat == null) {
            throw new JavaAVException("Could not encode audio. No audio format specified.");
        }
        ArrayList<MediaPacket> packets = new ArrayList<MediaPacket>();
        AudioFormat srcFormat = audioFrame.getAudioFormat();
        if (!srcFormat.equals(this.audioFormat)) {
            if (this.audioResampler == null) {
                this.audioResampler = new AudioResampler();
                this.audioResampler.open(srcFormat, this.audioFormat, this.avContext.frame_size());
            }
            frames = this.audioResampler.resample(audioFrame);
        } else {
            frames = new AudioFrame[]{audioFrame};
        }
        for (AudioFrame frame : frames) {
            avcodec.avcodec_get_frame_defaults((avutil.AVFrame)this.avFrame);
            for (int i = 0; i < frame.getPlaneCount(); ++i) {
                this.avFrame.data(i, frame.getPlane(i).position(0));
                this.avFrame.linesize(i, frame.getPlane(i).limit());
            }
            this.avFrame.nb_samples(frame.getSampleCount());
            this.avFrame.quality(this.avContext.global_quality());
            MediaPacket mediaPacket = this.encodeAudioFrame(this.avFrame);
            packets.add(mediaPacket);
        }
        return packets.toArray(new MediaPacket[0]);
    }

    public MediaPacket flushVideo() throws JavaAVException {
        return this.encodeVideo(null);
    }

    public MediaPacket flushAudio() throws JavaAVException {
        return this.encodeAudioFrame(null);
    }

    private MediaPacket encodeAudioFrame(avutil.AVFrame frame) throws JavaAVException {
        avcodec.av_init_packet((avcodec.AVPacket)this.avPacket);
        this.avPacket.data(this.audioBuffer);
        this.avPacket.size(this.audioBufferSize);
        if (frame != null) {
            if (frame.pts() == avutil.AV_NOPTS_VALUE) {
                frame.pts(this.sync_opts);
            }
            this.sync_opts = frame.pts() + (long)frame.nb_samples();
        }
        if (avcodec.avcodec_encode_audio2((avcodec.AVCodecContext)this.avContext, (avcodec.AVPacket)this.avPacket, (avutil.AVFrame)frame, (int[])this.gotFrame) < 0) {
            throw new JavaAVException("Could not encode audio packet.");
        }
        if (this.gotFrame[0] != 0) {
            avcodec.AVPacket copyPacket = new avcodec.AVPacket();
            avcodec.av_copy_packet((avcodec.AVPacket)copyPacket, (avcodec.AVPacket)this.avPacket);
            MediaPacket mediaPacket = new MediaPacket(copyPacket);
            mediaPacket.setKeyFrame(this.avFrame.key_frame() != 0);
            return mediaPacket;
        }
        return null;
    }

    private void createVideoBuffer() throws JavaAVException {
        this.picture = new avcodec.AVPicture();
        if (avcodec.avpicture_alloc((avcodec.AVPicture)this.picture, (int)this.avContext.pix_fmt(), (int)this.avContext.width(), (int)this.avContext.height()) < 0) {
            throw new JavaAVException("Could not allocate decoding picture.");
        }
        this.videoBufferSize = Math.max(262144, 8 * this.avContext.width() * this.avContext.height());
        this.videoBuffer = new BytePointer(avutil.av_malloc((long)this.videoBufferSize));
        int size = avcodec.avpicture_get_size((int)this.avContext.pix_fmt(), (int)this.avContext.width(), (int)this.avContext.height());
        this.pictureBuffer = new BytePointer(avutil.av_malloc((long)size));
        if (this.pictureBuffer.isNull()) {
            this.close();
            throw new JavaAVException("Could not allocate picture buffer.");
        }
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setSampleRate(int samplerate) throws JavaAVException {
        if (this.codec.getType() != MediaType.AUDIO) {
            throw new JavaAVException("Cannot set sample rate for non-audio codec.");
        }
        List<Integer> supportedRates = Arrays.asList(this.codec.getSupportedSampleRates());
        if (!supportedRates.contains(samplerate)) {
            samplerate = supportedRates.get(supportedRates.size() - 1);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Sample rate {} is not supported by {}.", new Object[]{samplerate, this.getCodec().getName()});
                LOGGER.warn("-> Selected supported sample rate {}.", new Object[]{samplerate});
            }
        }
        super.setSamplerate(samplerate);
    }

    public void setChannels(int channels) throws JavaAVException {
        if (this.codec.getType() != MediaType.AUDIO) {
            throw new JavaAVException("Cannot set audio channels for non-audio codec.");
        }
        ChannelLayout[] channelLayouts = this.getCodec().getSupportedChannelLayouts();
        if (channelLayouts != null) {
            long layout = avutil.av_get_default_channel_layout((int)channels);
            ChannelLayout channelLayout = ChannelLayout.byId(layout);
            List<ChannelLayout> layouts = Arrays.asList(channelLayouts);
            if (channelLayout == null || !layouts.contains((Object)channelLayout)) {
                int oldChannels = channels;
                channelLayout = ChannelLayout.STEREO;
                channels = avutil.av_get_channel_layout_nb_channels((long)channelLayout.value());
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Codec {} does not support {} channels and channel layout {}.", new Object[]{this.getCodec().getName(), oldChannels, channelLayout.asString()});
                    LOGGER.warn("-> Selected {} channels as default with channel layout {}.", new Object[]{channels, channelLayout});
                }
            }
        }
        super.setAudioChannels(channels);
    }

    @Override
    public void setFramerate(double framerate) throws JavaAVException {
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Cannot set frame rate for non-video codec.");
        }
        avutil.AVRational frameRate = avutil.av_d2q((double)framerate, (int)1001000);
        avutil.AVRational supportedFramerates = this.codec.getCodec().supported_framerates();
        if (supportedFramerates != null) {
            int idx = avutil.av_find_nearest_q_idx((avutil.AVRational)frameRate, (avutil.AVRational)supportedFramerates);
            frameRate = supportedFramerates.position(idx);
        }
        super.setFramerate(avutil.av_q2d((avutil.AVRational)frameRate));
    }

    @Override
    public void setImageWidth(int width) throws JavaAVException {
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Cannot set image width for non-video codec.");
        }
        if (width < 0) {
            throw new JavaAVException("Image width cannot be < 0.");
        }
        super.setImageWidth(width);
    }

    @Override
    public void setImageHeight(int height) throws JavaAVException {
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Cannot set image height for non-video codec.");
        }
        if (height < 0) {
            throw new JavaAVException("Image height cannot be < 0.");
        }
        super.setImageHeight(height);
    }

    @Override
    public void setGOPSize(int gopSize) throws JavaAVException {
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Cannot set Group Of Pictures for non-video codec.");
        }
        if (gopSize < 0) {
            throw new JavaAVException("Group Of Pictures cannot be < 0.");
        }
        super.setGOPSize(gopSize);
    }

    @Override
    public void setPixelFormat(PixelFormat format) throws JavaAVException {
        if (this.codec.getType() != MediaType.VIDEO) {
            throw new JavaAVException("Cannot set pixel format for non-video codec.");
        }
        List<PixelFormat> supportedFormats = Arrays.asList(this.codec.getSupportedPixelFormats());
        if (format == null || !supportedFormats.contains((Object)format)) {
            format = supportedFormats.get(0);
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No valid pixel format provided for codec: {}", new Object[]{this.getCodec().getName()});
                LOGGER.warn("-> Selected default supported pixel format: {}", new Object[]{format});
            }
        }
        super.setPixelFormat(format);
    }

    @Override
    public void setSampleFormat(SampleFormat format) throws JavaAVException {
        if (this.codec.getType() != MediaType.AUDIO) {
            throw new JavaAVException("Cannot set sample format for non-audio codec.");
        }
        if (format == null) {
            SampleFormat[] defaults;
            List<SampleFormat> supported = Arrays.asList(this.codec.getSupportedSampleFormats());
            for (SampleFormat defaultFormat : defaults = new SampleFormat[]{SampleFormat.S16, SampleFormat.S16P, SampleFormat.S32, SampleFormat.S32P, SampleFormat.FLT, SampleFormat.FLTP, SampleFormat.DBL, SampleFormat.DBLP}) {
                if (!supported.contains((Object)defaultFormat)) continue;
                format = defaultFormat;
                break;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No sample format provided for codec: {}", new Object[]{this.getCodec().getName()});
                LOGGER.warn("-> Selected default supported sample format: {}", new Object[]{format});
            }
        }
        if (format == null) {
            throw new JavaAVException("Could not set sample format. No format available.");
        }
        super.setSampleFormat(format);
    }
}

