/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.PixelFormat;
import com.github.hoary.javaav.VideoFrame;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class Image {
    public static PixelFormat getPixelFormat(BufferedImage image) {
        switch (image.getType()) {
            case 5: {
                return PixelFormat.BGR24;
            }
            case 6: 
            case 7: {
                return PixelFormat.ABGR;
            }
            case 12: {
                return PixelFormat.RGB444;
            }
            case 13: {
                return PixelFormat.RGB555;
            }
            case 10: {
                return PixelFormat.GRAY8;
            }
            case 2: 
            case 3: {
                return PixelFormat.ARGB;
            }
            case 1: {
                return PixelFormat.RGB24;
            }
            case 11: {
                return PixelFormat.GRAY16;
            }
            case 9: {
                return PixelFormat.RGB555;
            }
            case 8: {
                return PixelFormat.RGB565;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public static ByteBuffer createImageBuffer(BufferedImage image) {
        SampleModel model = image.getSampleModel();
        WritableRaster raster = image.getRaster();
        DataBuffer inBuffer = raster.getDataBuffer();
        ByteBuffer outBuffer = ByteBuffer.allocateDirect(image.getWidth() * image.getHeight() * model.getNumBands());
        int x = -raster.getSampleModelTranslateX();
        int y = -raster.getSampleModelTranslateY();
        int step = model.getWidth() * model.getNumBands();
        int channels = model.getNumBands();
        if (model instanceof ComponentSampleModel) {
            ComponentSampleModel compModel = (ComponentSampleModel)model;
            step = compModel.getScanlineStride();
            channels = ((ComponentSampleModel)model).getPixelStride();
        } else if (model instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singleModel = (SinglePixelPackedSampleModel)model;
            step = singleModel.getScanlineStride();
            channels = 1;
        } else if (model instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiModel = (MultiPixelPackedSampleModel)model;
            step = multiModel.getScanlineStride();
            channels = ((MultiPixelPackedSampleModel)model).getPixelBitStride() / 8;
        }
        int start = y * step + x * channels;
        if (inBuffer instanceof DataBufferByte) {
            byte[] a = ((DataBufferByte)inBuffer).getData();
            Image.copy(ByteBuffer.wrap(a, start, a.length - start), step, outBuffer, step, false);
        } else if (inBuffer instanceof DataBufferShort) {
            short[] a = ((DataBufferShort)inBuffer).getData();
            Image.copy(ShortBuffer.wrap(a, start, a.length - start), step, outBuffer.asShortBuffer(), step / 2, true);
        } else if (inBuffer instanceof DataBufferUShort) {
            short[] a = ((DataBufferUShort)inBuffer).getData();
            Image.copy(ShortBuffer.wrap(a, start, a.length - start), step, outBuffer.asShortBuffer(), step / 2, false);
        } else if (inBuffer instanceof DataBufferInt) {
            int[] a = ((DataBufferInt)inBuffer).getData();
            Image.copy(IntBuffer.wrap(a, start, a.length - start), step, outBuffer.asIntBuffer(), step / 4);
        } else if (inBuffer instanceof DataBufferFloat) {
            float[] a = ((DataBufferFloat)inBuffer).getData();
            Image.copy(FloatBuffer.wrap(a, start, a.length - start), step, outBuffer.asFloatBuffer(), step / 4);
        } else if (inBuffer instanceof DataBufferDouble) {
            double[] a = ((DataBufferDouble)inBuffer).getData();
            Image.copy(DoubleBuffer.wrap(a, start, a.length - start), step, outBuffer.asDoubleBuffer(), step / 8);
        }
        outBuffer.position(0);
        return outBuffer;
    }

    public static BufferedImage createImage(VideoFrame frame, int type) {
        return Image.createImage(frame.getData(), frame.getWidth(), frame.getHeight(), type);
    }

    public static BufferedImage createImage(ByteBuffer data, int width, int height, int type) {
        BufferedImage image = new BufferedImage(width, height, type);
        SampleModel model = image.getSampleModel();
        WritableRaster raster = image.getRaster();
        DataBuffer outBuffer = raster.getDataBuffer();
        int x = -raster.getSampleModelTranslateX();
        int y = -raster.getSampleModelTranslateY();
        int step = model.getWidth() * model.getNumBands();
        int channels = model.getNumBands();
        data.position(0).limit(height * width * channels);
        if (model instanceof ComponentSampleModel) {
            ComponentSampleModel compModel = (ComponentSampleModel)model;
            step = compModel.getScanlineStride();
            channels = compModel.getPixelStride();
        } else if (model instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singleModel = (SinglePixelPackedSampleModel)model;
            step = singleModel.getScanlineStride();
            channels = 1;
        } else if (model instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiModel = (MultiPixelPackedSampleModel)model;
            step = multiModel.getScanlineStride();
            channels = ((MultiPixelPackedSampleModel)model).getPixelBitStride() / 8;
        }
        int start = y * step + x * channels;
        if (outBuffer instanceof DataBufferByte) {
            byte[] a = ((DataBufferByte)outBuffer).getData();
            Image.copy(data, step, ByteBuffer.wrap(a, start, a.length - start), step, false);
        } else if (outBuffer instanceof DataBufferShort) {
            short[] a = ((DataBufferShort)outBuffer).getData();
            Image.copy(data.asShortBuffer(), step / 2, ShortBuffer.wrap(a, start, a.length - start), step, true);
        } else if (outBuffer instanceof DataBufferUShort) {
            short[] a = ((DataBufferUShort)outBuffer).getData();
            Image.copy(data.asShortBuffer(), step / 2, ShortBuffer.wrap(a, start, a.length - start), step, false);
        } else if (outBuffer instanceof DataBufferInt) {
            int[] a = ((DataBufferInt)outBuffer).getData();
            Image.copy(data.asIntBuffer(), step / 4, IntBuffer.wrap(a, start, a.length - start), step);
        } else if (outBuffer instanceof DataBufferFloat) {
            float[] a = ((DataBufferFloat)outBuffer).getData();
            Image.copy(data.asFloatBuffer(), step / 4, FloatBuffer.wrap(a, start, a.length - start), step);
        } else if (outBuffer instanceof DataBufferDouble) {
            double[] a = ((DataBufferDouble)outBuffer).getData();
            Image.copy(data.asDoubleBuffer(), step / 8, DoubleBuffer.wrap(a, start, a.length - start), step);
        }
        return image;
    }

    public static void copy(ByteBuffer srcBuf, int srcStep, ByteBuffer dstBuf, int dstStep, boolean signed) {
        int w = Math.min(srcStep, dstStep);
        int srcLine = srcBuf.position();
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
            for (int x = 0; x < w; ++x) {
                int in = signed ? srcBuf.get() : srcBuf.get() & 0xFF;
                byte out = (byte)in;
                dstBuf.put(out);
            }
        }
    }

    public static void copy(ShortBuffer srcBuf, int srcStep, ShortBuffer dstBuf, int dstStep, boolean signed) {
        int w = Math.min(srcStep, dstStep);
        int srcLine = srcBuf.position();
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
            for (int x = 0; x < w; ++x) {
                int in = signed ? srcBuf.get() : srcBuf.get() & 0xFFFF;
                short out = (short)in;
                dstBuf.put(out);
            }
        }
    }

    public static void copy(IntBuffer srcBuf, int srcStep, IntBuffer dstBuf, int dstStep) {
        int w = Math.min(srcStep, dstStep);
        int srcLine = srcBuf.position();
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
            for (int x = 0; x < w; ++x) {
                int in;
                int out = in = srcBuf.get();
                dstBuf.put(out);
            }
        }
    }

    public static void copy(FloatBuffer srcBuf, int srcStep, FloatBuffer dstBuf, int dstStep) {
        int w = Math.min(srcStep, dstStep);
        int srcLine = srcBuf.position();
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
            for (int x = 0; x < w; ++x) {
                float in;
                float out = in = srcBuf.get();
                dstBuf.put(out);
            }
        }
    }

    public static void copy(DoubleBuffer srcBuf, int srcStep, DoubleBuffer dstBuf, int dstStep) {
        int w = Math.min(srcStep, dstStep);
        int srcLine = srcBuf.position();
        for (int dstLine = dstBuf.position(); srcLine < srcBuf.capacity() && dstLine < dstBuf.capacity(); srcLine += srcStep, dstLine += dstStep) {
            srcBuf.position(srcLine);
            dstBuf.position(dstLine);
            w = Math.min(Math.min(w, srcBuf.remaining()), dstBuf.remaining());
            for (int x = 0; x < w; ++x) {
                double in;
                double out = in = srcBuf.get();
                dstBuf.put(out);
            }
        }
    }
}

