/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.AudioFrame;
import com.github.hoary.javaav.Codec;
import com.github.hoary.javaav.CodecFlag;
import com.github.hoary.javaav.Configurable;
import com.github.hoary.javaav.Encoder;
import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.MediaPacket;
import com.github.hoary.javaav.MediaType;
import com.github.hoary.javaav.Options;
import com.github.hoary.javaav.VideoFrame;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.avformat;
import com.googlecode.javacv.cpp.avutil;

public class Muxer
extends Configurable {
    private String outputPath;
    private avformat.AVOutputFormat outputFormat;
    private avformat.AVFormatContext formatContext;
    private avformat.AVStream videoStream;
    private avformat.AVStream audioStream;
    private Encoder videoEncoder;
    private Encoder audioEncoder;
    private Codec videoCodec;
    private Codec audioCodec;
    private Options videoOptions;
    private Options audioOptions;
    private int videoBitrate;
    private int audioBitrate;
    private double videoQuality = -1.0;
    private double audioQuality = -1.0;
    private boolean interleave = true;

    public Muxer(String outputPath) {
        this.outputPath = outputPath;
    }

    public void open() throws Exception {
        this.formatContext = null;
        this.videoStream = null;
        this.audioStream = null;
        String formatName = null;
        this.outputFormat = avformat.av_guess_format(formatName, (String)this.outputPath, null);
        if (this.outputFormat == null) {
            int proto = this.outputPath.indexOf("://");
            if (proto > 0) {
                formatName = this.outputPath.substring(0, proto);
            }
            if ((this.outputFormat = avformat.av_guess_format((String)formatName, (String)this.outputPath, null)) == null) {
                throw new JavaAVException("Could not guess output format for " + this.outputPath);
            }
        }
        if ((this.formatContext = avformat.avformat_alloc_context()) == null) {
            throw new JavaAVException("Could not allocate format context");
        }
        this.formatContext.oformat(this.outputFormat);
        this.formatContext.filename().putString(this.outputPath);
        if (this.getImageWidth() > 0 && this.getImageHeight() > 0) {
            this.outputFormat.video_codec(this.videoCodec.getID().value());
            this.videoStream = avformat.avformat_new_stream((avformat.AVFormatContext)this.formatContext, (avcodec.AVCodec)this.videoCodec.getCodec());
            if (this.videoStream == null) {
                this.release();
                throw new JavaAVException("Could not allocate video stream.");
            }
            this.videoEncoder = new Encoder(this.videoCodec, this.videoStream.codec());
            this.videoEncoder.setMediaType(MediaType.VIDEO);
            this.videoEncoder.setBitrate(this.getVideoBitrate());
            this.videoEncoder.setImageWidth((this.getImageWidth() + 15) / 16 * 16);
            this.videoEncoder.setImageHeight(this.getImageHeight());
            this.videoEncoder.setFramerate(this.getFramerate());
            this.videoEncoder.setGOPSize(this.getGOPSize());
            this.videoEncoder.setQuality(this.getVideoQuality());
            this.videoEncoder.setPixelFormat(this.getPixelFormat());
            this.videoEncoder.setProfile(578);
            if ((this.outputFormat.flags() & 0x40) != 0) {
                this.videoEncoder.setFlag(CodecFlag.GLOBAL_HEADER);
            }
        }
        if (this.getAudioChannels() > 0 && this.getAudioBitrate() > 0 && this.getSampleRate() > 0) {
            this.outputFormat.audio_codec(this.audioCodec.getID().value());
            this.audioStream = avformat.avformat_new_stream((avformat.AVFormatContext)this.formatContext, (avcodec.AVCodec)this.audioCodec.getCodec());
            if (this.audioStream == null) {
                this.release();
                throw new JavaAVException("Could not allocate audio stream.");
            }
            this.audioEncoder = new Encoder(this.audioCodec, this.audioStream.codec());
            this.audioEncoder.setMediaType(MediaType.AUDIO);
            this.audioEncoder.setBitrate(this.getAudioBitrate());
            this.audioEncoder.setSampleRate(this.getSampleRate());
            this.audioEncoder.setChannels(this.getAudioChannels());
            this.audioEncoder.setSampleFormat(this.getSampleFormat());
            this.audioEncoder.setQuality(this.getAudioQuality());
            if ((this.outputFormat.flags() & 0x40) != 0) {
                this.audioEncoder.setFlag(CodecFlag.GLOBAL_HEADER);
            }
        }
        avformat.av_dump_format((avformat.AVFormatContext)this.formatContext, (int)0, (String)this.outputPath, (int)1);
        if (this.videoStream != null) {
            this.videoEncoder.open(this.videoOptions);
        }
        if (this.audioStream != null) {
            this.audioEncoder.open(this.audioOptions);
        }
        if ((this.outputFormat.flags() & 1) == 0) {
            avformat.AVIOContext pb = new avformat.AVIOContext(null);
            if (avformat.avio_open((avformat.AVIOContext)pb, (String)this.outputPath, (int)2) < 0) {
                this.release();
                throw new JavaAVException("Could not open " + this.outputPath);
            }
            this.formatContext.pb(pb);
        }
        avformat.avformat_write_header((avformat.AVFormatContext)this.formatContext, (avutil.AVDictionary)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JavaAVException {
        if (this.formatContext != null) {
            try {
                while (this.videoStream != null && this.flushVideo()) {
                }
                while (this.audioStream != null && this.flushAudio()) {
                }
                if (this.interleave && this.videoStream != null && this.audioStream != null) {
                    avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.formatContext, null);
                } else {
                    avformat.av_write_frame((avformat.AVFormatContext)this.formatContext, null);
                }
                avformat.av_write_trailer((avformat.AVFormatContext)this.formatContext);
            }
            finally {
                this.release();
            }
        }
    }

    public MediaPacket addImage(VideoFrame frame) throws JavaAVException {
        MediaPacket mediaPacket = this.videoEncoder.encodeVideo(frame);
        if (mediaPacket != null) {
            avcodec.AVPacket avPacket = mediaPacket.getAVPacket();
            this.writeVideoPacket(avPacket);
        }
        return mediaPacket;
    }

    public MediaPacket[] addSamples(AudioFrame frame) throws JavaAVException {
        MediaPacket[] mediaPackets;
        for (MediaPacket mediaPacket : mediaPackets = this.audioEncoder.encodeAudio(frame)) {
            avcodec.AVPacket avPacket;
            if (mediaPacket == null || (avPacket = mediaPacket.getAVPacket()) == null) continue;
            this.writeAudioPacket(avPacket);
        }
        return mediaPackets;
    }

    public void setVideoCodec(Codec videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setAudioCodec(Codec audioCodec) {
        this.audioCodec = audioCodec;
    }

    public void setInterleave(boolean interleave) {
        this.interleave = interleave;
    }

    public void setVideoQuality(double videoQuality) {
        this.videoQuality = videoQuality;
    }

    public double getVideoQuality() {
        return this.videoQuality;
    }

    public void setAudioQuality(double audioQuality) {
        this.audioQuality = audioQuality;
    }

    public double getAudioQuality() {
        return this.audioQuality;
    }

    public void setVideoOptions(Options options) {
        this.videoOptions = options;
    }

    public void setAudioOptions(Options options) {
        this.audioOptions = options;
    }

    public void setVideoBitrate(int bitrate) {
        this.videoBitrate = bitrate;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setAudioBitrate(int bitrate) {
        this.audioBitrate = bitrate;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    private boolean flushVideo() throws JavaAVException {
        MediaPacket mediaPacket = this.videoEncoder.flushVideo();
        if (mediaPacket == null) {
            return false;
        }
        avcodec.AVPacket avPacket = mediaPacket.getAVPacket();
        this.writeVideoPacket(avPacket);
        return mediaPacket.isKeyFrame();
    }

    private boolean flushAudio() throws JavaAVException {
        MediaPacket mediaPacket = this.audioEncoder.flushAudio();
        if (mediaPacket == null) {
            return false;
        }
        avcodec.AVPacket avPacket = mediaPacket.getAVPacket();
        this.writeAudioPacket(avPacket);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVideoPacket(avcodec.AVPacket avPacket) throws JavaAVException {
        avutil.AVRational codecTimeBase = this.videoEncoder.getCodec().getContext().time_base();
        avutil.AVRational streamTimeBase = this.videoStream.time_base();
        if (avPacket.pts() != avutil.AV_NOPTS_VALUE) {
            avPacket.pts(avutil.av_rescale_q((long)avPacket.pts(), (avutil.AVRational)codecTimeBase, (avutil.AVRational)streamTimeBase));
        }
        if (avPacket.dts() != avutil.AV_NOPTS_VALUE) {
            avPacket.dts(avutil.av_rescale_q((long)avPacket.dts(), (avutil.AVRational)codecTimeBase, (avutil.AVRational)streamTimeBase));
        }
        avPacket.stream_index(this.videoStream.index());
        avformat.AVFormatContext aVFormatContext = this.formatContext;
        synchronized (aVFormatContext) {
            if (this.interleave && this.audioStream != null) {
                if (avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.formatContext, (avcodec.AVPacket)avPacket) < 0) {
                    throw new JavaAVException("Could not write interleaved video frame.");
                }
            } else if (avformat.av_write_frame((avformat.AVFormatContext)this.formatContext, (avcodec.AVPacket)avPacket) < 0) {
                throw new JavaAVException("Could not write video frame.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAudioPacket(avcodec.AVPacket avPacket) throws JavaAVException {
        avutil.AVRational timeBase = this.audioEncoder.getCodec().getContext().time_base();
        avutil.AVRational streamTimeBase = this.audioStream.time_base();
        if (avPacket.pts() != avutil.AV_NOPTS_VALUE) {
            avPacket.pts(avutil.av_rescale_q((long)avPacket.pts(), (avutil.AVRational)timeBase, (avutil.AVRational)streamTimeBase));
        }
        if (avPacket.dts() != avutil.AV_NOPTS_VALUE) {
            avPacket.dts(avutil.av_rescale_q((long)avPacket.dts(), (avutil.AVRational)timeBase, (avutil.AVRational)streamTimeBase));
        }
        if (avPacket.duration() > 0) {
            avPacket.duration((int)avutil.av_rescale_q((long)avPacket.duration(), (avutil.AVRational)timeBase, (avutil.AVRational)this.audioStream.time_base()));
        }
        avPacket.flags(avPacket.flags() | 1);
        avPacket.stream_index(this.audioStream.index());
        avformat.AVFormatContext aVFormatContext = this.formatContext;
        synchronized (aVFormatContext) {
            if (this.interleave && this.videoStream != null) {
                if (avformat.av_interleaved_write_frame((avformat.AVFormatContext)this.formatContext, (avcodec.AVPacket)avPacket) < 0) {
                    throw new JavaAVException("Could not write interleaved audio frame.");
                }
            } else if (avformat.av_write_frame((avformat.AVFormatContext)this.formatContext, (avcodec.AVPacket)avPacket) < 0) {
                throw new JavaAVException("Could not write audio frame.");
            }
        }
    }

    private void release() throws JavaAVException {
        if (this.videoEncoder != null) {
            this.videoEncoder.close();
            this.videoEncoder = null;
        }
        if (this.audioEncoder != null) {
            this.audioEncoder.close();
            this.audioEncoder = null;
        }
        if (this.formatContext != null && !this.formatContext.isNull()) {
            if ((this.outputFormat.flags() & 1) == 0) {
                avformat.avio_close((avformat.AVIOContext)this.formatContext.pb());
            }
            int nb_streams = this.formatContext.nb_streams();
            for (int i = 0; i < nb_streams; ++i) {
                avutil.av_free((Pointer)this.formatContext.streams(i));
            }
            avutil.av_free((Pointer)this.formatContext);
            this.formatContext = null;
        }
        this.videoStream = null;
        this.audioStream = null;
    }
}

