/*
 * Decompiled with CFR 0.152.
 */
package com.github.hoary.javaav;

import com.github.hoary.javaav.JavaAVException;
import com.github.hoary.javaav.PictureFormat;
import com.googlecode.javacpp.IntPointer;
import com.googlecode.javacpp.Pointer;
import com.googlecode.javacpp.PointerPointer;
import com.googlecode.javacv.cpp.avcodec;
import com.googlecode.javacv.cpp.swscale;

public class PictureResampler {
    private swscale.SwsContext convertContext;
    private PictureFormat srcFormat;
    private PictureFormat dstFormat;

    public void open(PictureFormat srcFormat, PictureFormat dstFormat) throws JavaAVException {
        if (srcFormat == null || dstFormat == null) {
            throw new JavaAVException("Invalid video format provided: from " + srcFormat + " to " + dstFormat);
        }
        if (srcFormat.equals(dstFormat)) {
            return;
        }
        this.convertContext = swscale.sws_getCachedContext((swscale.SwsContext)this.convertContext, (int)srcFormat.getWidth(), (int)srcFormat.getHeight(), (int)srcFormat.getFormat().value(), (int)dstFormat.getWidth(), (int)dstFormat.getHeight(), (int)dstFormat.getFormat().value(), (int)2, null, null, (double[])null);
        if (this.convertContext == null) {
            throw new JavaAVException("Could not initialize the image conversion context.");
        }
        this.srcFormat = srcFormat;
        this.dstFormat = dstFormat;
    }

    void resample(avcodec.AVPicture srcPicture, avcodec.AVPicture dstPicture) throws JavaAVException {
        swscale.sws_scale((swscale.SwsContext)this.convertContext, (PointerPointer)new PointerPointer((Pointer)srcPicture), (IntPointer)srcPicture.linesize(), (int)0, (int)this.srcFormat.getHeight(), (PointerPointer)new PointerPointer((Pointer)dstPicture), (IntPointer)dstPicture.linesize());
    }

    public void close() {
        if (this.convertContext != null) {
            swscale.sws_freeContext((swscale.SwsContext)this.convertContext);
            this.convertContext = null;
        }
    }
}

