/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PasswordMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLInitialResponse;
import com.github.jasync.sql.db.postgresql.messages.frontend.SASLResponse;
import com.github.jasync.sql.db.postgresql.util.PasswordHelper;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/PasswordEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "encodeSASLInitialResponse", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/SASLInitialResponse;", "encodeSASLResponse", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/SASLResponse;", "encodeSimplePassword", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/PasswordMessage;", "jasync-postgresql"})
@SourceDebugExtension(value={"SMAP\nPasswordEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordEncoder.kt\ncom/github/jasync/sql/db/postgresql/encoders/PasswordEncoder\n+ 2 KotlinUtils.kt\ncom/github/jasync/sql/db/util/KotlinUtilsKt\n*L\n1#1,63:1\n6#2:64\n*S KotlinDebug\n*F\n+ 1 PasswordEncoder.kt\ncom/github/jasync/sql/db/postgresql/encoders/PasswordEncoder\n*L\n24#1:64\n*E\n"})
public final class PasswordEncoder
implements Encoder {
    @NotNull
    private final Charset charset;

    public PasswordEncoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.charset = charset;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        ByteBuf byteBuf;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(message.getKind() == 112)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ClientMessage clientMessage = message;
        if (clientMessage instanceof PasswordMessage) {
            byteBuf = this.encodeSimplePassword((PasswordMessage)message);
        } else if (clientMessage instanceof SASLInitialResponse) {
            byteBuf = this.encodeSASLInitialResponse((SASLInitialResponse)message);
        } else if (clientMessage instanceof SASLResponse) {
            byteBuf = this.encodeSASLResponse((SASLResponse)message);
        } else {
            String reason$iv = "Unknown password message type " + message.getClass();
            boolean $i$f$XXX = false;
            throw new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
        }
        return byteBuf;
    }

    private final ByteBuf encodeSimplePassword(PasswordMessage message) {
        ByteBuf byteBuf;
        byte[] byArray;
        if (message.getSalt() == null) {
            byte[] byArray2 = message.getPassword().getBytes(this.charset);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        } else {
            byArray = PasswordHelper.encode(message.getUsername(), message.getPassword(), message.getSalt(), this.charset);
        }
        byte[] password = byArray;
        ByteBuf $this$encodeSimplePassword_u24lambda_u240 = byteBuf = Unpooled.buffer((int)(5 + password.length + 1));
        boolean bl = false;
        $this$encodeSimplePassword_u24lambda_u240.writeByte(112);
        $this$encodeSimplePassword_u24lambda_u240.writeInt(0);
        $this$encodeSimplePassword_u24lambda_u240.writeBytes(password);
        $this$encodeSimplePassword_u24lambda_u240.writeByte(0);
        ByteBufferUtils.writeLength((ByteBuf)$this$encodeSimplePassword_u24lambda_u240);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer(1 + 4 + password.\u2026iteLength(this)\n        }");
        return byteBuf2;
    }

    private final ByteBuf encodeSASLInitialResponse(SASLInitialResponse message) {
        ByteBuf byteBuf;
        ByteBuf $this$encodeSASLInitialResponse_u24lambda_u241 = byteBuf = Unpooled.buffer((int)(5 + message.getMechanism().length() + 1 + 4 + message.getSaslData().length()));
        boolean bl = false;
        $this$encodeSASLInitialResponse_u24lambda_u241.writeByte(112);
        $this$encodeSASLInitialResponse_u24lambda_u241.writeInt(0);
        byte[] byArray = message.getMechanism().getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$encodeSASLInitialResponse_u24lambda_u241.writeBytes(byArray);
        $this$encodeSASLInitialResponse_u24lambda_u241.writeByte(0);
        $this$encodeSASLInitialResponse_u24lambda_u241.writeInt(message.getSaslData().length());
        byte[] byArray2 = message.getSaslData().getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        $this$encodeSASLInitialResponse_u24lambda_u241.writeBytes(byArray2);
        ByteBufferUtils.writeLength((ByteBuf)$this$encodeSASLInitialResponse_u24lambda_u241);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer(1 + 4 + message.m\u2026iteLength(this)\n        }");
        return byteBuf2;
    }

    private final ByteBuf encodeSASLResponse(SASLResponse message) {
        ByteBuf byteBuf;
        ByteBuf $this$encodeSASLResponse_u24lambda_u242 = byteBuf = Unpooled.buffer((int)(5 + message.getSaslData().length()));
        boolean bl = false;
        $this$encodeSASLResponse_u24lambda_u242.writeByte(112);
        $this$encodeSASLResponse_u24lambda_u242.writeInt(0);
        byte[] byArray = message.getSaslData().getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$encodeSASLResponse_u24lambda_u242.writeBytes(byArray);
        ByteBufferUtils.writeLength((ByteBuf)$this$encodeSASLResponse_u24lambda_u242);
        ByteBuf byteBuf2 = byteBuf;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"buffer(1 + 4 + message.s\u2026iteLength(this)\n        }");
        return byteBuf2;
    }
}

