/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.encoders;

import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.encoders.Encoder;
import com.github.jasync.sql.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.jasync.sql.db.postgresql.encoders.PreparedStatementOpeningEncoderKt;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/github/jasync/sql/db/postgresql/encoders/PreparedStatementOpeningEncoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/Encoder;", "Lcom/github/jasync/sql/db/postgresql/encoders/PreparedStatementEncoderHelper;", "charset", "Ljava/nio/charset/Charset;", "encoder", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getEncoder", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class PreparedStatementOpeningEncoder
implements Encoder,
PreparedStatementEncoderHelper {
    @NotNull
    private final Charset charset;
    @NotNull
    private final ColumnEncoderRegistry encoder;

    public PreparedStatementOpeningEncoder(@NotNull Charset charset, @NotNull ColumnEncoderRegistry encoder) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        this.charset = charset;
        this.encoder = encoder;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoder() {
        return this.encoder;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        PreparedStatementOpeningMessage m = (PreparedStatementOpeningMessage)message;
        String string = m.getStatementId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.statementId.toString()");
        String string2 = string;
        byte[] byArray = string2.getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] statementIdBytes = byArray;
        int columnCount = m.getValueTypes().size();
        ByteBuf parseBuffer = Unpooled.buffer((int)1024);
        parseBuffer.writeByte(80);
        parseBuffer.writeInt(0);
        parseBuffer.writeBytes(statementIdBytes);
        parseBuffer.writeByte(0);
        byte[] byArray2 = m.getQuery().getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        parseBuffer.writeBytes(byArray2);
        parseBuffer.writeByte(0);
        parseBuffer.writeShort(columnCount);
        if (PreparedStatementOpeningEncoderKt.access$getLogger$p().isDebugEnabled()) {
            PreparedStatementOpeningEncoderKt.access$getLogger$p().debug("Opening query (" + m.getQuery() + ") - statement id (" + ArraysKt.joinToString$default((byte[])statementIdBytes, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null) + ") - selected types (" + CollectionsKt.joinToString$default((Iterable)m.getValueTypes(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ") - values (" + CollectionsKt.joinToString$default((Iterable)m.getValues(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        Iterator<Integer> iterator = m.getValueTypes().iterator();
        while (iterator.hasNext()) {
            int kind = ((Number)iterator.next()).intValue();
            parseBuffer.writeInt(kind);
        }
        ByteBufferUtils.writeLength((ByteBuf)parseBuffer);
        ByteBuf executeBuffer = this.writeExecutePortal(statementIdBytes, m.getQuery(), m.getValues(), this.encoder, this.charset, true);
        ByteBuf[] byteBufArray = new ByteBuf[]{parseBuffer, executeBuffer};
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuf[])byteBufArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(parseBuffer, executeBuffer)");
        return byteBuf;
    }

    @Override
    @NotNull
    public ByteBuf writeExecutePortal(@NotNull byte[] statementIdBytes, @NotNull String query, @NotNull List<? extends Object> values, @NotNull ColumnEncoderRegistry encoder, @NotNull Charset charset, boolean writeDescribe) {
        return PreparedStatementEncoderHelper.DefaultImpls.writeExecutePortal(this, statementIdBytes, query, values, encoder, charset, writeDescribe);
    }

    @Override
    @NotNull
    public ByteBuf closeAndSyncBuffer(@NotNull byte[] statementIdBytes, char closeType) {
        return PreparedStatementEncoderHelper.DefaultImpls.closeAndSyncBuffer(this, statementIdBytes, closeType);
    }
}

