/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.jena;

import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.jena.JenaRDFParser;
import com.github.jsonldjava.utils.JSONUtils;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Action;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterDatasetRIOTBase;

class JsonLDWriter
extends WriterDatasetRIOTBase {
    private final RDFFormat format;

    public JsonLDWriter(RDFFormat syntaxForm) {
        this.format = syntaxForm;
    }

    public Lang getLang() {
        return this.format.getLang();
    }

    public void write(Writer out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        this.serialize(out, dataset, prefixMap, baseURI);
    }

    private boolean isPretty() {
        return RDFFormat.PRETTY.equals((Object)this.format.getVariant());
    }

    public void write(OutputStream out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        OutputStreamWriter w = new OutputStreamWriter(out, Chars.charsetUTF8);
        this.write(w, dataset, prefixMap, baseURI, context);
        IO.flush((Writer)w);
    }

    private void serialize(Writer writer, DatasetGraph dataset, PrefixMap prefixMap, String baseURI) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        this.addProperties(ctx, dataset.getDefaultGraph());
        JsonLDWriter.addPrefixes(ctx, prefixMap);
        try {
            JsonLdOptions opts = new JsonLdOptions(baseURI);
            opts.setUseRdfType(Boolean.valueOf(true));
            opts.setUseNativeTypes(Boolean.valueOf(true));
            opts.setCompactArrays(Boolean.valueOf(true));
            JsonLdApi api = new JsonLdApi(opts);
            JenaRDFParser parser = new JenaRDFParser();
            RDFDataset result = parser.parse(dataset);
            Object obj = api.fromRDF(result);
            HashMap<String, LinkedHashMap<String, Object>> localCtx = new HashMap<String, LinkedHashMap<String, Object>>();
            localCtx.put("@context", ctx);
            obj = JsonLdProcessor.compact((Object)obj, localCtx, (JsonLdOptions)opts);
            if (this.isPretty()) {
                JSONUtils.writePrettyPrint((Writer)writer, (Object)obj);
            } else {
                JSONUtils.write((Writer)writer, (Object)obj);
            }
        }
        catch (IOException e) {
            throw new RiotException("Could not write JSONLD: " + e, (Throwable)e);
        }
        catch (JsonLdError e) {
            throw new RiotException("Could not process JSONLD: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private static void addPrefixes(Map<String, Object> ctx, PrefixMap prefixMap) {
        Map pmap = prefixMap.getMapping();
        for (Map.Entry e : pmap.entrySet()) {
            ctx.put((String)e.getKey(), ((IRI)e.getValue()).toString());
        }
    }

    private void addProperties(final Map<String, Object> ctx, Graph graph) {
        final HashSet dups = new HashSet();
        Action<Triple> x = new Action<Triple>(){

            public void apply(Triple item) {
                Node p = item.getPredicate();
                if (p.equals((Object)RDF.type.asNode())) {
                    return;
                }
                String x = p.getLocalName();
                if (dups.contains(x)) {
                    return;
                }
                if (!ctx.containsKey(x)) {
                    LinkedHashMap<String, String> x2 = new LinkedHashMap<String, String>();
                    x2.put("@id", p.getURI());
                    x2.put("@type", "@id");
                    ctx.put(x, x2);
                }
            }
        };
        Iter.iter((Iterator)graph.find(null, null, null)).apply((Action)x);
    }
}

