/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.rdf2go;

import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import java.util.List;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.ModelSet;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;

public class RDF2GoTripleCallback
implements JsonLdTripleCallback {
    private final ModelSet sinkModel = RDF2Go.getModelFactory().createModelSet();

    public RDF2GoTripleCallback() {
        this.sinkModel.open();
    }

    private void triple(String s, String p, String o, String graph) {
        this.triple((Resource)this.sinkModel.createURI(s), this.sinkModel.createURI(p), (Node)this.sinkModel.createURI(o), graph);
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        Object object = null;
        object = language != null ? this.sinkModel.createLanguageTagLiteral(value, language) : (datatype != null ? this.sinkModel.createDatatypeLiteral(value, this.sinkModel.createURI(datatype)) : this.sinkModel.createPlainLiteral(value));
        this.triple((Resource)this.sinkModel.createURI(s), this.sinkModel.createURI(p), (Node)object, graph);
    }

    private void triple(Resource subject, URI predicate, Node object, String graph) {
        URI context = graph == null ? null : this.sinkModel.createURI(graph);
        this.sinkModel.addStatement(context, subject, predicate, object);
    }

    public Object call(RDFDataset dataset) {
        for (String graphName : dataset.keySet()) {
            List quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        return this.sinkModel;
    }
}

