/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain;

import com.github.katenachain.api.Handler;
import com.github.katenachain.crypto.ED25519.PrivateKey;
import com.github.katenachain.crypto.Nacl.PublicKey;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.TxData;
import com.github.katenachain.entity.TxDataState;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.entity.certify.CertificateEd25519V1;
import com.github.katenachain.entity.certify.CertificateRawV1;
import com.github.katenachain.entity.certify.SecretNaclBoxV1;
import com.github.katenachain.serializer.Serializer;
import java.io.IOException;
import java.util.Date;

public class Transactor {
    private static final String FORMAT_ID = "%s-%s";
    private PrivateKey txSigner;
    private Handler apiHandler;
    private String companyChainId;
    private String chainId;
    private Serializer serializer = new Serializer();

    public Transactor(String apiUrl, String chainId, String companyChainId, PrivateKey txSigner) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = chainId;
        this.txSigner = txSigner;
        this.companyChainId = companyChainId;
    }

    public Transactor(String apiUrl) {
        this.apiHandler = new Handler(apiUrl, this.serializer);
        this.chainId = "";
        this.txSigner = null;
        this.companyChainId = "";
    }

    public TxStatus sendCertificateRawV1(String uuid, byte[] value) throws Exception {
        CertificateRawV1 certificate = new CertificateRawV1();
        certificate.setId(this.formatBcid(this.companyChainId, uuid)).setValue(value);
        Tx tx = this.getTx(certificate);
        return this.apiHandler.sendCertificate(tx);
    }

    public TxStatus sendCertificateEd25519V1(String uuid, com.github.katenachain.crypto.ED25519.PublicKey signer, byte[] signature) throws Exception {
        CertificateEd25519V1 certificate = new CertificateEd25519V1();
        certificate.setId(this.formatBcid(this.companyChainId, uuid)).setSigner(signer).setSignature(signature);
        Tx tx = this.getTx(certificate);
        return this.apiHandler.sendCertificate(tx);
    }

    public TxWrapper retrieveCertificate(String companyChainId, String uuid) throws IOException {
        return this.apiHandler.retrieveCertificate(this.formatBcid(companyChainId, uuid));
    }

    public TxWrappers retrieveCertificatesHistory(String companyChainId, String uuid) throws IOException {
        return this.apiHandler.retrieveCertificatesHistory(this.formatBcid(companyChainId, uuid));
    }

    public TxStatus sendSecretNaclBoxV1(String uuid, PublicKey sender, byte[] nonce, byte[] content) throws Exception {
        SecretNaclBoxV1 secret = new SecretNaclBoxV1();
        secret.setId(this.formatBcid(this.companyChainId, uuid)).setNonce(nonce).setSender(sender).setContent(content);
        Tx tx = this.getTx(secret);
        return this.apiHandler.sendSecret(tx);
    }

    public TxWrappers retrieveSecrets(String companyChainId, String uuid) throws IOException {
        return this.apiHandler.retrieveSecrets(this.formatBcid(companyChainId, uuid));
    }

    public Tx getTx(TxData txData) throws Exception {
        if (this.txSigner == null || this.companyChainId == null) {
            throw new Exception("impossible to create txs without a private key or company chain id");
        }
        Date nonceTime = new Date();
        byte[] txDataState = this.getTxDataState(this.chainId, nonceTime, txData);
        Tx tx = new Tx();
        tx.setSigner(this.txSigner.getPublicKey()).setSignature(this.txSigner.sign(txDataState)).setData(txData).setNonceTime(nonceTime);
        return tx;
    }

    public byte[] getTxDataState(String chainId, Date nonceTime, TxData txData) {
        return this.serializer.serialize(new TxDataState(chainId, nonceTime, txData)).getBytes();
    }

    protected String formatBcid(String companyChainId, String uuid) {
        return String.format(FORMAT_ID, companyChainId, uuid);
    }
}

