/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.api.RawResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class Client {
    private String apiUrl;

    public Client(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public RawResponse get(String route) throws IOException {
        return this.doRequest("GET", route, "", new HashMap<String, String>());
    }

    public RawResponse get(String route, HashMap<String, String> queryValues) throws IOException {
        return this.doRequest("GET", route, "", queryValues);
    }

    public RawResponse post(String route, String body) throws IOException {
        return this.doRequest("POST", route, body, new HashMap<String, String>());
    }

    public RawResponse post(String route, String body, HashMap<String, String> queryValues) throws IOException {
        return this.doRequest("POST", route, body, queryValues);
    }

    private RawResponse doRequest(String method, String route, String body, HashMap<String, String> queryValues) throws IOException {
        String inputLine;
        DataOutputStream out;
        URL url = new URL(this.apiUrl + route);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(method);
        con.setDoOutput(true);
        if (!body.isEmpty()) {
            out = new DataOutputStream(con.getOutputStream());
            out.write(body.getBytes());
            out.flush();
            out.close();
        }
        if (!queryValues.isEmpty()) {
            out = new DataOutputStream(con.getOutputStream());
            out.write(Client.getParamsString(queryValues));
            out.flush();
            out.close();
        }
        int status = con.getResponseCode();
        InputStreamReader streamReader = null;
        streamReader = status > 299 ? new InputStreamReader(con.getErrorStream()) : new InputStreamReader(con.getInputStream());
        BufferedReader in = new BufferedReader(streamReader);
        StringBuffer content = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        in.close();
        con.disconnect();
        return new RawResponse(status, content.toString());
    }

    private static byte[] getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        byte[] resultBytes = result.toString().getBytes("UTF-8");
        return resultBytes;
    }
}

