/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.api.Client;
import com.github.katenachain.api.RawResponse;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.serializer.Serializer;
import java.io.IOException;

public class Handler {
    private static final String ROUTE_CETIFICATES = "certificates";
    private static final String ROUTE_SECRETS = "secrets";
    private static final String PATH_CERTIFY = "certify";
    private static final String PATH_HISTORY = "history";
    private Client apiClient;
    private Serializer serializer;

    public Handler(String apiUrl, Serializer serializer) {
        this.apiClient = new Client(apiUrl);
        this.serializer = serializer;
    }

    public TxStatus sendCertificate(Tx tx) throws IOException {
        Object[] objectArray = new Object[2];
        objectArray[0] = ROUTE_CETIFICATES;
        objectArray[1] = PATH_CERTIFY;
        return this.sendTx(String.format("/%s/%s", objectArray), tx);
    }

    public TxStatus sendSecret(Tx tx) throws IOException {
        Object[] objectArray = new Object[2];
        objectArray[0] = ROUTE_SECRETS;
        objectArray[1] = PATH_CERTIFY;
        return this.sendTx(String.format("/%s/%s", objectArray), tx);
    }

    public TxWrapper retrieveCertificate(String id) throws IOException {
        Object[] objectArray = new Object[2];
        objectArray[0] = ROUTE_CETIFICATES;
        objectArray[1] = id;
        RawResponse apiResponse = this.apiClient.get(String.format("/%s/%s", objectArray));
        return (TxWrapper)this.serializer.deserialize(apiResponse.getContent(), TxWrapper.class);
    }

    public TxWrappers retrieveCertificatesHistory(String id) throws IOException {
        Object[] objectArray = new Object[3];
        objectArray[0] = ROUTE_CETIFICATES;
        objectArray[1] = id;
        objectArray[2] = PATH_HISTORY;
        RawResponse apiResponse = this.apiClient.get(String.format("/%s/%s/%s", objectArray));
        return (TxWrappers)this.serializer.deserialize(apiResponse.getContent(), TxWrappers.class);
    }

    public TxWrappers retrieveSecrets(String id) throws IOException {
        Object[] objectArray = new Object[2];
        objectArray[0] = ROUTE_SECRETS;
        objectArray[1] = id;
        RawResponse apiResponse = this.apiClient.get(String.format("/%s/%s", objectArray));
        return (TxWrappers)this.serializer.deserialize(apiResponse.getContent(), TxWrappers.class);
    }

    public TxStatus sendTx(String route, Tx tx) throws IOException {
        RawResponse apiResponse = this.apiClient.post(route, this.serializer.serialize(tx));
        return (TxStatus)this.serializer.deserialize(apiResponse.getContent(), TxStatus.class);
    }
}

