/*
 * Decompiled with CFR 0.152.
 */
package com.github.katenachain.api;

import com.github.katenachain.api.Client;
import com.github.katenachain.entity.Tx;
import com.github.katenachain.entity.api.RawResponse;
import com.github.katenachain.entity.api.TxStatus;
import com.github.katenachain.entity.api.TxWrapper;
import com.github.katenachain.entity.api.TxWrappers;
import com.github.katenachain.exceptions.ApiException;
import com.github.katenachain.serializer.Serializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class Handler {
    private static final String ROUTE_CERTIFICATES = "certificates";
    private static final String ROUTE_SECRETS = "secrets";
    private static final String PATH_CERTIFY = "certify";
    private static final String PATH_HISTORY = "history";
    private Client apiClient;
    private Serializer serializer;

    public Handler(String apiUrl, Serializer serializer) {
        this.apiClient = new Client(apiUrl);
        this.serializer = serializer;
    }

    public TxStatus sendCertificate(Tx tx) throws IOException, ApiException {
        return this.sendTx(String.format("%s/%s", ROUTE_CERTIFICATES, PATH_CERTIFY), tx);
    }

    public TxStatus sendSecret(Tx tx) throws IOException, ApiException {
        return this.sendTx(String.format("%s/%s", ROUTE_SECRETS, PATH_CERTIFY), tx);
    }

    public TxWrapper retrieveCertificate(String id) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", ROUTE_CERTIFICATES, id));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrapper)this.serializer.deserialize(jsonBody, TxWrapper.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrappers retrieveCertificatesHistory(String id) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s/%s", ROUTE_CERTIFICATES, id, PATH_HISTORY));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrappers)this.serializer.deserialize(jsonBody, TxWrappers.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxWrappers retrieveSecrets(String id) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.get(String.format("%s/%s", ROUTE_SECRETS, id));
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 200) {
            return (TxWrappers)this.serializer.deserialize(jsonBody, TxWrappers.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }

    public TxStatus sendTx(String route, Tx tx) throws IOException, ApiException {
        RawResponse apiResponse = this.apiClient.post(route, this.serializer.serialize(tx).getBytes());
        String jsonBody = new String(apiResponse.getBody(), StandardCharsets.UTF_8);
        if (apiResponse.getStatusCode() == 202) {
            return (TxStatus)this.serializer.deserialize(jsonBody, TxStatus.class);
        }
        throw (ApiException)this.serializer.deserialize(jsonBody, ApiException.class);
    }
}

