/*
 * Decompiled with CFR 0.152.
 */
package com.github.lambdaexpression.resolver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.lambdaexpression.annotation.RequestBodyParam;
import com.github.lambdaexpression.exception.HttpMediaTypeOrHttpBodyException;
import com.github.lambdaexpression.exception.MethodArgumentNotValidException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RequestBodyParamArgumentResolver
implements HandlerMethodArgumentResolver {
    private static boolean hasNestedIfOptional = true;

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestBodyParam.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Map data;
        parameter = this.nestedIfOptional(parameter);
        RequestBodyParam requestBodyParam = (RequestBodyParam)parameter.getParameterAnnotation(RequestBodyParam.class);
        String json = ((ServletWebRequest)webRequest).getRequest().getReader().lines().collect(Collectors.joining(System.lineSeparator()));
        try {
            data = (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        }
        catch (JSONException e) {
            throw new HttpMediaTypeOrHttpBodyException(parameter);
        }
        String name = StringUtils.isEmpty((Object)requestBodyParam.name()) ? parameter.getParameterName() : requestBodyParam.name();
        Object param = data.get(name);
        this.check(parameter, param, name, requestBodyParam);
        mavContainer.addAttribute(BindingResult.MODEL_KEY_PREFIX + name, param);
        if (param instanceof Map || param instanceof List) {
            return JSON.parseObject((String)param.toString(), (Class)parameter.getParameterType());
        }
        return param;
    }

    private MethodParameter nestedIfOptional(MethodParameter parameter) {
        if (hasNestedIfOptional) {
            try {
                return parameter.nestedIfOptional();
            }
            catch (NoSuchMethodError e) {
                hasNestedIfOptional = false;
                return this.nested(parameter);
            }
        }
        return this.nested(parameter);
    }

    private MethodParameter nested(MethodParameter parameter) {
        parameter = new MethodParameter(parameter);
        parameter.increaseNestingLevel();
        return parameter;
    }

    private void check(MethodParameter parameter, Object param, String name, RequestBodyParam requestBodyParam) throws MethodArgumentNotValidException {
        if (Objects.isNull(param) && requestBodyParam.required()) {
            throw new MethodArgumentNotValidException(parameter, name + " is Null ");
        }
        if (Objects.isNull(param)) {
            return;
        }
        if (Objects.equals(param.getClass(), parameter.getParameterType())) {
            return;
        }
        if (Objects.equals(param.getClass(), JSONArray.class) && parameter.getParameterType().isArray()) {
            return;
        }
        if (Objects.equals(param.getClass(), JSONObject.class) && this.isDto(parameter.getParameterType())) {
            return;
        }
        throw new MethodArgumentNotValidException(parameter, name + " argument type mismatch ");
    }

    private boolean isDto(Class<?> classz) {
        return !Objects.equals(classz, Integer.class) && !Objects.equals(classz, Float.class) && !Objects.equals(classz, Double.class) && !Objects.equals(classz, Byte.class) && !Objects.equals(classz, Boolean.class) && !Objects.equals(classz, Character.class) && !Objects.equals(classz, Short.class) && !Objects.equals(classz, Long.class) && !Objects.equals(classz, String.class);
    }
}

