/*
 * Decompiled with CFR 0.152.
 */
package com.github.lujinfeifly.freejava.basic;

import java.util.HashMap;
import java.util.Map;

public class MGpsUtil {
    private static double EARTH_RADIUS = 6378.137;
    private static char[] base32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7'};
    private static final Map<Character, Integer> decodemap = new HashMap<Character, Integer>();
    private static int precision;
    private static int[] bits;

    public static void setPrecision(int precision) {
        MGpsUtil.precision = precision;
    }

    public static double getPrecision(double x, double precision) {
        double base = Math.pow(10.0, -precision);
        double diff = x % base;
        return x - diff;
    }

    public static String encode(double latitude, double longitude) {
        double[] lat_interval = new double[]{-90.0, 90.0};
        double[] lon_interval = new double[]{-180.0, 180.0};
        StringBuilder geohash = new StringBuilder();
        boolean is_even = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid = 0.0;
            if (is_even) {
                mid = (lon_interval[0] + lon_interval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= bits[bit];
                    lon_interval[0] = mid;
                } else {
                    lon_interval[1] = mid;
                }
            } else {
                mid = (lat_interval[0] + lat_interval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= bits[bit];
                    lat_interval[0] = mid;
                } else {
                    lat_interval[1] = mid;
                }
            }
            boolean bl = is_even = !is_even;
            if (bit < 2) {
                ++bit;
                continue;
            }
            geohash.append(base32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static double[] decode(String geohash) {
        double[] ge = MGpsUtil.decode_exactly(geohash);
        double lat = ge[0];
        double lon = ge[1];
        double lat_err = ge[2];
        double lon_err = ge[3];
        double lat_precision = Math.max(1L, Math.round(-Math.log10(lat_err))) - 1L;
        double lon_precision = Math.max(1L, Math.round(-Math.log10(lon_err))) - 1L;
        lat = MGpsUtil.getPrecision(lat, lat_precision);
        lon = MGpsUtil.getPrecision(lon, lon_precision);
        return new double[]{lat, lon};
    }

    public static double[] decode_exactly(String geohash) {
        double[] lat_interval = new double[]{-90.0, 90.0};
        double[] lon_interval = new double[]{-180.0, 180.0};
        double lat_err = 90.0;
        double lon_err = 180.0;
        boolean is_even = true;
        int sz = geohash.length();
        int bsz = bits.length;
        for (int i = 0; i < sz; ++i) {
            int cd = decodemap.get(Character.valueOf(geohash.charAt(i)));
            for (int z = 0; z < bsz; ++z) {
                int mask = bits[z];
                if (is_even) {
                    lon_err /= 2.0;
                    if ((cd & mask) != 0) {
                        lon_interval[0] = (lon_interval[0] + lon_interval[1]) / 2.0;
                    } else {
                        lon_interval[1] = (lon_interval[0] + lon_interval[1]) / 2.0;
                    }
                } else {
                    lat_err /= 2.0;
                    if ((cd & mask) != 0) {
                        lat_interval[0] = (lat_interval[0] + lat_interval[1]) / 2.0;
                    } else {
                        lat_interval[1] = (lat_interval[0] + lat_interval[1]) / 2.0;
                    }
                }
                is_even = !is_even;
            }
        }
        double latitude = (lat_interval[0] + lat_interval[1]) / 2.0;
        double longitude = (lon_interval[0] + lon_interval[1]) / 2.0;
        return new double[]{latitude, longitude, lat_err, lon_err};
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double distanceFromGps(String gs, double lng, double lat) {
        MGpsUtil ghf = new MGpsUtil();
        double[] gd1 = MGpsUtil.decode(gs);
        double radLat1 = MGpsUtil.rad(lat);
        double radLat2 = MGpsUtil.rad(gd1[0]);
        double radLon1 = MGpsUtil.rad(lng);
        double radLon2 = MGpsUtil.rad(gd1[1]);
        if (radLat1 < 0.0) {
            radLat1 = 1.5707963267948966 + Math.abs(radLat1);
        }
        if (radLat1 > 0.0) {
            radLat1 = 1.5707963267948966 - Math.abs(radLat1);
        }
        if (radLon1 < 0.0) {
            radLon1 = Math.PI * 2 - Math.abs(radLon1);
        }
        if (radLat2 < 0.0) {
            radLat2 = 1.5707963267948966 + Math.abs(radLat2);
        }
        if (radLat2 > 0.0) {
            radLat2 = 1.5707963267948966 - Math.abs(radLat2);
        }
        if (radLon2 < 0.0) {
            radLon2 = Math.PI * 2 - Math.abs(radLon2);
        }
        double x1 = EARTH_RADIUS * Math.cos(radLon1) * Math.sin(radLat1);
        double y1 = EARTH_RADIUS * Math.sin(radLon1) * Math.sin(radLat1);
        double z1 = EARTH_RADIUS * Math.cos(radLat1);
        double x2 = EARTH_RADIUS * Math.cos(radLon2) * Math.sin(radLat2);
        double y2 = EARTH_RADIUS * Math.sin(radLon2) * Math.sin(radLat2);
        double z2 = EARTH_RADIUS * Math.cos(radLat2);
        double d = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
        double theta = Math.acos((EARTH_RADIUS * EARTH_RADIUS + EARTH_RADIUS * EARTH_RADIUS - d * d) / (2.0 * EARTH_RADIUS * EARTH_RADIUS));
        double dist = theta * EARTH_RADIUS;
        return dist;
    }

    public static void main(String[] args) {
        MGpsUtil ghf = new MGpsUtil();
        String gc1 = MGpsUtil.encode(39.915808, 116.212389);
        String gc5 = MGpsUtil.encode(39.913328, 116.211374);
        String gc2 = MGpsUtil.encode(39.914044, 116.280481);
        String gc3 = MGpsUtil.encode(39.914044, 116.404662);
        String gc4 = MGpsUtil.encode(39.914044, 116.551122);
        String gc6 = MGpsUtil.encode(36.749136, 117.652937);
        System.out.println("\u878d\u79d1\uff1a    " + gc1);
        System.out.println("\u4eac\u71d5\uff1a    " + gc5);
        System.out.println("\u4e94\u68f5\u677e\uff1a" + gc2);
        System.out.println("\u5929\u5b89\u95e8\uff1a" + gc3);
        System.out.println("\u4e1c\u56db\u73af\uff1a" + gc4);
        System.out.println("\u6d4e\u5357\u54c8\uff1a" + gc6);
        double a = MGpsUtil.distanceFromGps("71644330065702", 116.211374, 39.913328);
        double[] gd1 = MGpsUtil.decode("71644330065702");
        double[] gd2 = MGpsUtil.decode(gc2);
        System.out.println(gd1[0] + ", " + gd1[1]);
        System.out.println(gd2[0] + ", " + gd2[1]);
        System.out.println(a);
    }

    static {
        int sz = base32.length;
        for (int i = 0; i < sz; ++i) {
            decodemap.put(Character.valueOf(base32[i]), i);
        }
        precision = 14;
        bits = new int[]{4, 2, 1};
    }
}

