/*
 * Decompiled with CFR 0.152.
 */
package com.github.lujinfeifly.freejava.basic;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MTime {
    private String commonFormat = "yyyy-MM-dd HH:mm:ss";
    private Date time;

    public MTime(long itime) {
        this.time = new Date(itime);
    }

    public MTime(Date date) {
        this.time = date;
    }

    public MTime(String strTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(strTime);
        }
        catch (ParseException e) {
            date = new Date(0L);
        }
        this.time = date;
    }

    public long getTime() {
        return this.time.getTime();
    }

    public String getCommonTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(this.commonFormat);
        return sdf.format(this.time);
    }

    public String getSpecialTime(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(this.time);
    }

    public long timeDiffNow() {
        return this.time.getTime() - new Date().getTime() / 1000L;
    }

    public static String getHumenTime(long time) {
        String year;
        SimpleDateFormat HourFormat = new SimpleDateFormat("HH:mm");
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        long now = System.currentTimeMillis();
        String hour = HourFormat.format(time);
        String[] hours = hour.split(":");
        String timedup = "";
        if (hours.length == 2) {
            int dhour = Integer.parseInt(hours[0]);
            int dmini = Integer.parseInt(hours[1]);
            timedup = MTime.getTimeDup(dhour, dmini);
        }
        String nowDay = dayFormat.format(now);
        String yesterday = dayFormat.format(now - 86400000L);
        String day = dayFormat.format(time);
        if (nowDay.equals(day)) {
            return new SimpleDateFormat(timedup + "HH:mm").format(time);
        }
        if (nowDay.equals(yesterday)) {
            return new SimpleDateFormat("\u6628\u5929 " + timedup + "HH:mm").format(time);
        }
        String nowYear = yearFormat.format(now);
        if (!nowYear.equals(year = yearFormat.format(time))) {
            return new SimpleDateFormat("yyyy-MM-dd " + timedup + "HH:mm").format(time);
        }
        return new SimpleDateFormat("MM-dd " + timedup + "HH:mm").format(time);
    }

    public static String getTimeDup(int hour, int mini) {
        if (hour >= 0 && hour < 7) {
            return "\u51cc\u6668";
        }
        if (hour >= 7 && hour < 12) {
            return "\u4e0a\u5348";
        }
        if (hour >= 12 && hour < 13) {
            return "\u4e2d\u5348";
        }
        if (hour >= 13 && hour < 19) {
            return "\u4e0b\u5348";
        }
        if (hour >= 19 && hour < 24) {
            return "\u665a\u4e0a";
        }
        return "";
    }
}

