/*
 * Decompiled with CFR 0.152.
 */
package com.github.lujinfeifly.freejava.http;

import com.github.lujinfeifly.freejava.basic.MString;
import com.github.lujinfeifly.freejava.bean.MNameValuePair;
import com.github.lujinfeifly.freejava.http.HttpRet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUrl {
    public static final String BOUNDARYSTR = "----WebKitFormBoundaryDwwA7U9966TVkJIR";
    public static final String BOUNDARY = "------WebKitFormBoundaryDwwA7U9966TVkJIR\r\n";
    static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static String paserList(List<MNameValuePair> param) {
        StringBuilder sb = new StringBuilder();
        int count = param.size();
        if (count >= 1) {
            sb.append(param.get(0).getName() + "=" + param.get(0).getValue());
        }
        for (int i = 1; i < count; ++i) {
            sb.append("&" + param.get(i).getName() + "=" + param.get(i).getValue());
        }
        return sb.toString();
    }

    public static HttpRet sendGetRequest(String url, List<MNameValuePair> param, String sessionId, String userAgent) {
        return MUrl.sendGetRequest(url, MUrl.paserList(param), sessionId, userAgent);
    }

    public static HttpRet sendPostRequest(String url, List<MNameValuePair> param, String sessionId, String userAgent) {
        return MUrl.sendPostRequest(url, MUrl.paserList(param), sessionId, userAgent);
    }

    public static HttpRet sendGetRequest(String url, String param, String sessionId) {
        return MUrl.sendGetRequest(url, param, sessionId, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10532");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRet sendGetRequest(String url, String param, String sessionId, String userAgent) {
        HttpRet ret = new HttpRet();
        String strRet = "";
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = MString.isNotEmpty(param) ? url + "?" + param : url;
            URL realUrl = new URL(urlNameString);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            if (conn instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new MyTrustManager()}, new SecureRandom());
                if (sslContext != null) {
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
                }
            }
            conn.setRequestProperty("Cache-Control", "max-age=0");
            conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", userAgent);
            conn.setRequestProperty("Upgrade-Insecure-Requests", "1");
            conn.setRequestProperty("Refer", "http://dynamic.watch/users/sign_in");
            conn.setInstanceFollowRedirects(false);
            if (MString.isNotEmpty(sessionId)) {
                conn.setRequestProperty("Cookie", sessionId);
            }
            conn.connect();
            int icode = conn.getResponseCode();
            String session_value = conn.getHeaderField("Set-Cookie");
            ret.setmSessionId(session_value);
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                strRet = strRet + line;
            }
            ret.setmRetCode(icode);
            if (icode == 302) {
                ret.setmRetContent(conn.getHeaderField("Location"));
            } else if (icode < 400) {
                ret.setmRetContent(strRet);
            }
        }
        catch (MalformedURLException me) {
            ret.setmRetCode(400);
            me.printStackTrace();
        }
        catch (IOException ie) {
            ret.setmRetCode(510);
            ie.printStackTrace();
        }
        catch (Exception e) {
            ret.setmRetCode(511);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                ret.setmRetCode(512);
                e2.printStackTrace();
            }
        }
        return ret;
    }

    public static HttpRet sendPostRequest(String url, String param, String sessionId) {
        return MUrl.sendPostRequest(url, param, sessionId, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10532");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRet sendPostRequest(String url, String param, String sessionId, String userAgent) {
        HttpRet ret = new HttpRet();
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            if (conn instanceof HttpsURLConnection) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new MyTrustManager()}, new SecureRandom());
                if (sslContext != null) {
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setInstanceFollowRedirects(false);
            conn.setRequestProperty("Cache-Control", "max-age=0");
            conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
            conn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", userAgent);
            conn.setRequestProperty("Upgrade-Insecure-Requests", "1");
            if (MString.isNotEmpty(sessionId)) {
                conn.setRequestProperty("Cookie", sessionId);
            }
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(param.getBytes());
            outputStream.close();
            String session_value = conn.getHeaderField("Set-Cookie");
            ret.setmSessionId(session_value);
            int icode = conn.getResponseCode();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
            ret.setmRetCode(icode);
            if (icode == 302) {
                ret.setmRetContent(conn.getHeaderField("Location"));
            } else if (icode < 400) {
                ret.setmRetContent(result);
            }
        }
        catch (MalformedURLException me) {
            ret.setmRetCode(400);
            me.printStackTrace();
        }
        catch (IOException ie) {
            ret.setmRetCode(510);
            ie.printStackTrace();
        }
        catch (Exception e) {
            ret.setmRetCode(511);
            e.printStackTrace();
        }
        return ret;
    }

    public static HttpRet uploadFile(String url, List<MNameValuePair> param, File file, String sessionId) {
        return MUrl.uploadFile(url, param, file, sessionId, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.135 Safari/537.36 Edge/12.10532");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpRet uploadFile(String url, List<MNameValuePair> param, File file, String sessionId, String userAgent) {
        HttpRet ret = new HttpRet();
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            SSLContext sslContext;
            URL realUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            if (conn instanceof HttpsURLConnection && (sslContext = SSLContext.getDefault()) != null) {
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setInstanceFollowRedirects(false);
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.8");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", userAgent);
            conn.setRequestProperty("Refer", "http://dynamic.watch/routes/new");
            conn.setRequestProperty("Content-type", "multipart/form-data; boundary=----WebKitFormBoundaryDwwA7U9966TVkJIR");
            conn.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            if (MString.isNotEmpty(sessionId)) {
                conn.setRequestProperty("Cookie", sessionId);
            }
            StringBuilder sb = new StringBuilder();
            for (MNameValuePair pair : param) {
                sb.append(BOUNDARY);
                sb.append("Content-Disposition: form-data; name=\"");
                sb.append(pair.getName());
                sb.append("\"\r\n\r\n");
                sb.append(pair.getValue());
                sb.append("\r\n");
            }
            sb.append(BOUNDARY);
            sb.append("Content-Disposition: form-data; name=\"file\"; filename=\"");
            sb.append(MString.getFileNameWithoutType(file.getName()));
            sb.append("\"\r\n");
            sb.append("Content-Type: application/octet-stream");
            sb.append("\r\n\r\n");
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(sb.toString().getBytes());
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = fis.read(buffer)) != -1) {
                outputStream.write(buffer, 0, count);
            }
            fis.close();
            outputStream.write("\r\n\r\n".getBytes());
            outputStream.write("------WebKitFormBoundaryDwwA7U9966TVkJIR--\r\n".getBytes());
            outputStream.close();
            String session_value = conn.getHeaderField("Set-Cookie");
            ret.setmSessionId(session_value);
            int icode = conn.getResponseCode();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
            ret.setmRetCode(icode);
            if (icode < 400) {
                ret.setmRetContent(result);
            }
        }
        catch (MalformedURLException me) {
            ret.setmRetCode(400);
            me.printStackTrace();
        }
        catch (IOException ie) {
            ret.setmRetCode(510);
            ie.printStackTrace();
        }
        catch (Exception e) {
            ret.setmRetCode(511);
            e.printStackTrace();
        }
        return ret;
    }

    private static void trustAllHosts() {
        String TAG = "trustAllHosts";
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        HttpRet ret1 = MUrl.sendGetRequest("https://dynamic.watch/users/sign_in", "", "");
        System.out.println(ret1.toString());
        String bbb = "";
        if (ret1.getmRetCode() == 200) {
            Document doc = Jsoup.parse((String)ret1.getmRetContent());
            Elements contents = doc.getElementsByAttributeValue("name", "authenticity_token");
            Element content = contents.get(0);
            bbb = content.attr("value");
            System.out.println(bbb);
        }
        HttpRet ret2 = MUrl.sendPostRequest("https://dynamic.watch/users/sign_in", "utf8=%E2%9C%93&authenticity_token=" + URLEncoder.encode(bbb) + "&user%5Bemail%5D=736214397%40qq.com&user%5Bpassword%5D=lujinfei123.&user%5Bremember_me%5D=0&commit=Log+in", ret1.getmSessionId());
        System.out.println(ret2.toString());
        HttpRet ret4 = MUrl.sendGetRequest("http://dynamic.watch/me", "", ret2.getmSessionId());
        System.out.println(ret4.toString());
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private MyTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    static class myHostnameVerifier
    implements HostnameVerifier {
        myHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    static class myX509TrustManager
    implements X509TrustManager {
        myX509TrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

