/*
 * Decompiled with CFR 0.152.
 */
package tss;

import java.nio.ByteBuffer;
import java.util.Stack;
import tss.TpmMarshaller;
import tss.TpmStructure;

public class InByteBuf {
    ByteBuffer b;
    public Stack<SizedStructInfo> structSize;

    public InByteBuf(byte[] buf) {
        this.b = ByteBuffer.wrap(buf);
        this.structSize = new Stack();
    }

    public byte readByte() {
        return this.b.get();
    }

    public short readShort() {
        return this.b.getShort();
    }

    public int readInt() {
        return this.b.getInt();
    }

    public long readLong() {
        return this.b.getLong();
    }

    public int readInt(int numBytes) {
        if (numBytes == 1) {
            return this.readByte() & 0xFF;
        }
        if (numBytes == 2) {
            return this.readShort() & 0xFFFF;
        }
        if (numBytes == 4) {
            return this.readInt();
        }
        throw new RuntimeException();
    }

    public byte[] readByteArray(int numBytes) {
        byte[] buf = new byte[numBytes];
        this.b.get(buf);
        return buf;
    }

    public void readArrayOfInts(Object arrX, int intSize, int numElems) {
        if (arrX instanceof byte[]) {
            byte[] arrB = (byte[])arrX;
            for (int j = 0; j < numElems; ++j) {
                arrB[j] = (byte)this.readInt(intSize);
            }
            return;
        }
        Object[] arr = (Object[])arrX;
        for (int j = 0; j < numElems; ++j) {
            arr[j] = this.readInt(intSize);
        }
    }

    public void readArrayOfTpmObjects(Object arrX, int numElems) {
        TpmStructure[] arr = (TpmStructure[])arrX;
        for (int j = 0; j < numElems; ++j) {
            arr[j].initFromTpm(this);
        }
    }

    public void readTpmObject(TpmMarshaller m) {
    }

    public int curPos() {
        return this.b.position();
    }

    public int bytesRemaining() {
        return this.b.remaining();
    }

    public byte[] getRemaining() {
        return this.readByteArray(this.bytesRemaining());
    }

    public byte[] peekRemaining() {
        byte[] res = this.getRemaining();
        this.b.position(0);
        return res;
    }

    public class SizedStructInfo {
        public int StartPos;
        public int Size;

        public SizedStructInfo(int startPos, int size) {
            this.StartPos = startPos;
            this.Size = size;
        }
    }
}

