/*
 * Decompiled with CFR 0.152.
 */
package tss;

import tss.Tpm;
import tss.TpmDeviceBase;
import tss.TpmDeviceLinux;
import tss.TpmDeviceTbs;
import tss.TpmDeviceTcp;
import tss.tpm.TPM_HANDLE;
import tss.tpm.TPM_RH;
import tss.tpm.TPM_SU;

public class TpmFactory {
    public static Tpm localTpmSimulator() {
        Tpm tpm = new Tpm();
        TpmDeviceTcp device = new TpmDeviceTcp("localhost", 2321);
        ((TpmDeviceBase)device).powerCycle();
        tpm = new Tpm();
        tpm._setDevice(device);
        tpm.Startup(TPM_SU.CLEAR);
        tpm.DictionaryAttackLockReset(TPM_HANDLE.from(TPM_RH.LOCKOUT));
        return tpm;
    }

    public static Tpm remoteTpmSimulator(String hostName) {
        Tpm tpm = new Tpm();
        TpmDeviceTcp device = new TpmDeviceTcp(hostName, 2321);
        ((TpmDeviceBase)device).powerCycle();
        tpm._setDevice(device);
        tpm.Startup(TPM_SU.CLEAR);
        tpm.DictionaryAttackLockReset(TPM_HANDLE.from(TPM_RH.LOCKOUT));
        return tpm;
    }

    public static Tpm platformTpm() {
        Tpm tpm = new Tpm();
        String osName = System.getProperty("os.name");
        System.out.println("OS NAME: " + osName);
        tpm._setDevice(osName.contains("Windows") ? new TpmDeviceTbs() : new TpmDeviceLinux());
        return tpm;
    }
}

