/*
 * Decompiled with CFR 0.152.
 */
package tss.tpm;

import tss.InByteBuf;
import tss.OutByteBuf;
import tss.TpmStructure;
import tss.TpmStructurePrinter;

public class GetRandomResponse
extends TpmStructure {
    public byte[] randomBytes;

    public GetRandomResponse(byte[] _randomBytes) {
        this.randomBytes = _randomBytes;
    }

    public GetRandomResponse() {
    }

    @Override
    public void toTpm(OutByteBuf buf) {
        buf.writeInt(this.randomBytes != null ? this.randomBytes.length : 0, 2);
        buf.write(this.randomBytes);
    }

    @Override
    public void initFromTpm(InByteBuf buf) {
        int _randomBytesSize = buf.readInt(2);
        this.randomBytes = new byte[_randomBytesSize];
        buf.readArrayOfInts(this.randomBytes, 1, _randomBytesSize);
    }

    @Override
    public byte[] toTpm() {
        OutByteBuf buf = new OutByteBuf();
        this.toTpm(buf);
        return buf.getBuf();
    }

    public static GetRandomResponse fromTpm(byte[] x) {
        GetRandomResponse ret = new GetRandomResponse();
        InByteBuf buf = new InByteBuf(x);
        ret.initFromTpm(buf);
        if (buf.bytesRemaining() != 0) {
            throw new AssertionError((Object)"bytes remaining in buffer after object was de-serialized");
        }
        return ret;
    }

    public static GetRandomResponse fromTpm(InByteBuf buf) {
        GetRandomResponse ret = new GetRandomResponse();
        ret.initFromTpm(buf);
        return ret;
    }

    public String toString() {
        TpmStructurePrinter _p = new TpmStructurePrinter("TPM2_GetRandom_RESPONSE");
        this.toStringInternal(_p, 1);
        _p.endStruct();
        return _p.toString();
    }

    @Override
    public void toStringInternal(TpmStructurePrinter _p, int d) {
        _p.add(d, "byte", "randomBytes", this.randomBytes);
    }
}

