/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool;

import com.github.paganini2008.devtools.beans.ToStringBuilder;
import com.github.paganini2008.devtools.date.DateUtils;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.objectpool.ObjectDetail;
import com.github.paganini2008.devtools.objectpool.ObjectFactory;
import com.github.paganini2008.devtools.objectpool.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class GenericObjectPool
implements ObjectPool {
    private static final Log log = LogFactory.getLog(GenericObjectPool.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final LinkedList<Object> busyQueue = new LinkedList();
    private final LinkedList<Object> idleQueue = new LinkedList();
    private final IdentityHashMap<Object, PooledObject> pooledObjects = new IdentityHashMap();
    private int maxPoolSize = 8;
    private int minIdleSize = 1;
    private int maxIdleSize;
    private int maxUses = -1;
    private long checkIdleSizeInterval = 60000L;
    private int maxTestTimes = 3;
    private volatile int poolSize;
    private boolean testWhileIdle;
    private long testWhileIdleInterval = 3000L;
    private boolean checkObjectExpired;
    private long checkObjectExpiredInterval = 60000L;
    private long maxWaitTimeForExpiration = 60000L;
    private final AtomicBoolean running;
    private ScheduledExecutorService timer;
    private final ObjectFactory objectFactory;
    private final Comparator<Object> idleQueueSorter = new Comparator<Object>(){

        @Override
        public int compare(Object left, Object right) {
            PooledObject leftDetail = (PooledObject)GenericObjectPool.this.pooledObjects.get(left);
            PooledObject rightDetail = (PooledObject)GenericObjectPool.this.pooledObjects.get(right);
            return rightDetail.getUses() - leftDetail.getUses();
        }
    };

    public GenericObjectPool(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.timer = Executors.newScheduledThreadPool(3);
        this.running = new AtomicBoolean(true);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMaxIdleSize() {
        return this.maxIdleSize;
    }

    public int getMinIdleSize() {
        return this.minIdleSize;
    }

    public void setMinIdleSize(int minIdleSize) {
        this.minIdleSize = minIdleSize;
    }

    public int getIdleSize() {
        return this.idleQueue.size();
    }

    public int getBusySize() {
        return this.busyQueue.size();
    }

    public void setMaxIdleSize(int maxIdleSize) {
        if (maxIdleSize > 0) {
            this.maxIdleSize = maxIdleSize;
            this.timer.scheduleAtFixedRate(new CheckIdleSizeTask(), this.checkIdleSizeInterval, this.checkIdleSizeInterval, TimeUnit.MILLISECONDS);
        }
    }

    public long getCheckIdleSizeInterval() {
        return this.checkIdleSizeInterval;
    }

    public void setCheckIdleSizeInterval(long checkIdleSizeInterval) {
        this.checkIdleSizeInterval = checkIdleSizeInterval;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (testWhileIdle) {
            this.timer.scheduleAtFixedRate(new TestWhileIdleTask(), this.testWhileIdleInterval, this.testWhileIdleInterval, TimeUnit.MILLISECONDS);
        }
    }

    public long getTestWhileIdleInterval() {
        return this.testWhileIdleInterval;
    }

    public void setTestWhileIdleInterval(long testWhileIdleInterval) {
        this.testWhileIdleInterval = testWhileIdleInterval;
    }

    public boolean isCheckObjectExpired() {
        return this.checkObjectExpired;
    }

    public void setCheckObjectExpired(boolean checkObjectExpired) {
        this.checkObjectExpired = checkObjectExpired;
        if (checkObjectExpired) {
            this.timer.scheduleAtFixedRate(new CheckObjectExpiredTask(), this.checkObjectExpiredInterval, this.checkObjectExpiredInterval, TimeUnit.MILLISECONDS);
        }
    }

    public long getMaxWaitTimeForExpiration() {
        return this.maxWaitTimeForExpiration;
    }

    public void setMaxWaitTimeForExpiration(long maxWaitTimeForExpiration) {
        this.maxWaitTimeForExpiration = maxWaitTimeForExpiration;
    }

    public int getMaxTestTimes() {
        return this.maxTestTimes;
    }

    public void setMaxTestTimes(int maxTestTimes) {
        this.maxTestTimes = maxTestTimes;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public long getCheckObjectExpiredInterval() {
        return this.checkObjectExpiredInterval;
    }

    public void setCheckObjectExpiredInterval(long checkObjectExpiredInterval) {
        this.checkObjectExpiredInterval = checkObjectExpiredInterval;
    }

    @Override
    public ObjectDetail getDetail(Object object) {
        return this.pooledObjects.get(object);
    }

    @Override
    public Object borrowObject() throws Exception {
        while (this.running.get()) {
            block10: {
                Object newObject;
                Object availableObject;
                block9: {
                    this.lock.lock();
                    try {
                        availableObject = this.idleQueue.pollFirst();
                        if (availableObject == null) break block9;
                        Object object = this.testWhileBorrow(availableObject);
                        this.lock.unlock();
                        return object;
                    }
                    catch (Throwable throwable) {
                        this.lock.unlock();
                        throw throwable;
                    }
                }
                if (this.poolSize < this.maxPoolSize) {
                    newObject = this.objectFactory.createObject();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create new object: " + newObject));
                    }
                    availableObject = this.testWhileBorrow(newObject);
                    this.busyQueue.add(availableObject);
                    ++this.poolSize;
                }
                if (availableObject == null) break block10;
                newObject = availableObject;
                this.lock.unlock();
                return newObject;
            }
            try {
                this.condition.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ignored) {
                this.lock.unlock();
                break;
            }
            this.lock.unlock();
        }
        throw new IllegalStateException("Can not borrow any object now.");
    }

    public Object borrowObject(long timeout, TimeUnit timeUnit) throws Exception {
        return this.borrowObject(DateUtils.convertToMillis((long)timeout, (TimeUnit)timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object borrowObject(long timeout) throws Exception {
        long begin = System.nanoTime();
        long m = DateUtils.convertToNanos((long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
        while (this.running.get()) {
            block13: {
                block12: {
                    Object newObject;
                    Object availableObject;
                    block11: {
                        this.lock.lock();
                        availableObject = this.idleQueue.pollFirst();
                        if (availableObject == null) break block11;
                        Object object = this.testWhileBorrow(availableObject);
                        this.lock.unlock();
                        return object;
                    }
                    if (this.poolSize < this.maxPoolSize) {
                        newObject = this.objectFactory.createObject();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Create new object: " + newObject));
                        }
                        availableObject = this.testWhileBorrow(newObject);
                        this.busyQueue.add(availableObject);
                        ++this.poolSize;
                    }
                    if (availableObject == null) break block12;
                    newObject = availableObject;
                    this.lock.unlock();
                    return newObject;
                }
                if (m <= 0L) break block13;
                try {
                    this.condition.awaitNanos(m);
                }
                catch (InterruptedException ignored) {
                    this.lock.unlock();
                    break;
                }
                long elapsed = System.nanoTime() - begin;
                m -= elapsed;
                continue;
            }
            this.lock.unlock();
            break;
            finally {
                this.lock.unlock();
            }
        }
        throw new IllegalStateException("Can not borrow any object now.");
    }

    private Object testWhileIdle(Object object) {
        int i = 0;
        Exception cause = null;
        do {
            try {
                if (this.objectFactory.testObject(object)) {
                    PooledObject pooledObject = this.pooledObjects.get(object);
                    pooledObject.setLastTested(System.currentTimeMillis());
                    return object;
                }
            }
            catch (Exception e) {
                cause = e;
            }
        } while (i++ < this.maxTestTimes);
        throw new IllegalStateException("Can not borrow any object now.", cause);
    }

    private Object testWhileBorrow(Object object) {
        int i = 0;
        Exception cause = null;
        do {
            try {
                if (this.objectFactory.testObject(object)) {
                    PooledObject pooledObject = this.pooledObjects.get(object);
                    if (pooledObject == null) {
                        this.pooledObjects.put(object, PooledObject.of(object));
                        pooledObject = this.pooledObjects.get(object);
                    }
                    pooledObject.setLastBorrowed(System.currentTimeMillis());
                    pooledObject.setUses(pooledObject.getUses() + 1);
                    return object;
                }
            }
            catch (Exception e) {
                cause = e;
            }
        } while (i++ < this.maxTestTimes);
        throw new IllegalStateException("Can not borrow any object now.", cause);
    }

    @Override
    public void givebackObject(Object object) throws Exception {
        block7: {
            this.lock.lock();
            try {
                PooledObject pooledObject = this.pooledObjects.get(object);
                if (pooledObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Giveback object: " + object));
                    }
                    if (pooledObject.getUses() == this.maxUses) {
                        this.discardObject(pooledObject.getObject());
                    } else {
                        this.busyQueue.remove(pooledObject.getObject());
                        this.idleQueue.add(pooledObject.getObject());
                        pooledObject.setLastReturned(System.currentTimeMillis());
                        this.condition.signalAll();
                    }
                    break block7;
                }
                throw new IllegalStateException("Unpooled object!");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardObject(Object object) throws Exception {
        block7: {
            this.lock.lock();
            try {
                PooledObject pooledObject = this.pooledObjects.remove(object);
                if (pooledObject == null) break block7;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroy object: " + object));
                }
                this.busyQueue.remove(pooledObject.getObject());
                try {
                    this.objectFactory.destroyObject(pooledObject.getObject());
                }
                finally {
                    --this.poolSize;
                    this.condition.signalAll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.running.set(false);
        ExecutorUtils.gracefulShutdown((Executor)this.timer, (long)60000L);
        this.lock.lock();
        try {
            while (!this.busyQueue.isEmpty()) {
                ThreadUtils.randomSleep((long)1000L);
            }
            while (!this.idleQueue.isEmpty()) {
                Object idleObject = this.idleQueue.pollLast();
                try {
                    this.objectFactory.destroyObject(idleObject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pooledObjects.remove(idleObject);
                --this.poolSize;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    class CheckObjectExpiredTask
    implements Runnable {
        CheckObjectExpiredTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GenericObjectPool.this.lock.lock();
            try {
                for (Object busyObject : GenericObjectPool.this.busyQueue) {
                    PooledObject pooledObject = (PooledObject)GenericObjectPool.this.pooledObjects.get(busyObject);
                    if (System.currentTimeMillis() - pooledObject.getLastBorrowed() <= GenericObjectPool.this.maxWaitTimeForExpiration) continue;
                    try {
                        GenericObjectPool.this.discardObject(busyObject);
                        log.warn((Object)("Discard expired object: " + busyObject));
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                GenericObjectPool.this.lock.unlock();
            }
        }
    }

    class CheckIdleSizeTask
    implements Runnable {
        CheckIdleSizeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GenericObjectPool.this.lock.lock();
            try {
                if (GenericObjectPool.this.idleQueue.size() > GenericObjectPool.this.maxIdleSize) {
                    ArrayList queue = new ArrayList(GenericObjectPool.this.idleQueue);
                    Collections.sort(queue, GenericObjectPool.this.idleQueueSorter);
                    int destroyedSize = queue.size() - GenericObjectPool.this.maxIdleSize;
                    for (int i = 0; i < destroyedSize; ++i) {
                        Object object = queue.get(i);
                        if (!GenericObjectPool.this.idleQueue.remove(object)) continue;
                        try {
                            GenericObjectPool.this.discardObject(object);
                            log.warn((Object)("Discard redundant object: " + object));
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                GenericObjectPool.this.lock.unlock();
            }
        }
    }

    class TestWhileIdleTask
    implements Runnable {
        TestWhileIdleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GenericObjectPool.this.lock.lock();
            try {
                if (GenericObjectPool.this.idleQueue.size() > GenericObjectPool.this.minIdleSize) {
                    ArrayList invalidObjects = new ArrayList();
                    for (Object idleObject : GenericObjectPool.this.idleQueue) {
                        try {
                            GenericObjectPool.this.testWhileIdle(idleObject);
                        }
                        catch (Exception e) {
                            invalidObjects.add(idleObject);
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (invalidObjects.size() > 0) {
                        for (Object invalidObject : invalidObjects) {
                            try {
                                GenericObjectPool.this.discardObject(invalidObject);
                                log.warn((Object)("Discard invalid object: " + invalidObject));
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            finally {
                GenericObjectPool.this.lock.unlock();
            }
        }
    }

    static class PooledObject
    implements ObjectDetail {
        private final long created = System.currentTimeMillis();
        private final Object object;
        private long lastBorrowed;
        private long lastReturned;
        private long lastTested;
        private int uses;

        PooledObject(Object object) {
            this.object = object;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public long getLastBorrowed() {
            return this.lastBorrowed;
        }

        public void setLastBorrowed(long lastBorrowed) {
            this.lastBorrowed = lastBorrowed;
        }

        @Override
        public long getLastReturned() {
            return this.lastReturned;
        }

        public void setLastReturned(long lastReturned) {
            this.lastReturned = lastReturned;
        }

        @Override
        public long getLastTested() {
            return this.lastTested;
        }

        public void setLastTested(long lastTested) {
            this.lastTested = lastTested;
        }

        @Override
        public int getUses() {
            return this.uses;
        }

        public void setUses(int uses) {
            this.uses = uses;
        }

        public static PooledObject of(Object object) {
            return new PooledObject(object);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

