/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.objectpool.GenericObjectPool;
import com.github.paganini2008.devtools.objectpool.dbpool.ConnectionFactory;
import com.github.paganini2008.devtools.objectpool.dbpool.DailyQueryStatistics;
import com.github.paganini2008.devtools.objectpool.dbpool.PooledConnection;
import com.github.paganini2008.devtools.objectpool.dbpool.QuerySpan;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

public class ConnectionPool {
    private static final Log logger = LogFactory.getLog(ConnectionPool.class);
    private final ConnectionFactory connectionFactory;
    private final GenericObjectPool objectPool;
    private DailyQueryStatistics queryStatistics = new DailyQueryStatistics();
    private long maxWaitTime = 60000L;

    public ConnectionPool() {
        this.connectionFactory = new ConnectionFactory(this);
        this.objectPool = new GenericObjectPool(this.connectionFactory);
    }

    public void setUser(String username) {
        this.connectionFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.connectionFactory.setPassword(password);
    }

    public void setDriverClassName(String driverClassName) {
        this.connectionFactory.setDriverClassName(driverClassName);
    }

    public void setUrl(String url) {
        this.connectionFactory.setUrl(url);
    }

    public void setTestSql(String testSql) {
        this.connectionFactory.setTestSql(testSql);
    }

    public void setAutoCommit(boolean autoCommit) {
        this.connectionFactory.setAutoCommit(autoCommit);
    }

    public void setDefaultTransactionIsolationLevel(int defaultTransactionIsolationLevel) {
        this.connectionFactory.setDefaultTransactionIsolationLevel(defaultTransactionIsolationLevel);
    }

    public void setStatementCacheSize(int statementCacheSize) {
        this.connectionFactory.setStatementCacheSize(statementCacheSize);
    }

    public void setMaxIdleSize(int maxIdleSize) {
        this.objectPool.setMaxIdleSize(maxIdleSize);
    }

    public void setMaxSize(int maxSize) {
        this.objectPool.setMaxPoolSize(maxSize);
    }

    public void setMaxUses(int maxAge) {
        this.objectPool.setMaxUses(maxAge);
    }

    public void setMaxWaitTime(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.objectPool.setTestWhileIdle(testWhileIdle);
    }

    public void setTestWhileIdleInterval(long testWhileIdleInterval) {
        this.objectPool.setTestWhileIdleInterval(testWhileIdleInterval);
    }

    public void setCheckObjectExpired(boolean checkObjectExpired) {
        this.objectPool.setCheckObjectExpired(checkObjectExpired);
    }

    public void setCheckObjectExpiredInterval(long checkObjectExpiredInterval) {
        this.objectPool.setCheckObjectExpiredInterval(checkObjectExpiredInterval);
    }

    public void setMaxWaitTimeForExpiration(long maxWaitTimeForExpiration) {
        this.objectPool.setMaxWaitTimeForExpiration(maxWaitTimeForExpiration);
    }

    public Map<String, QuerySpan> getStatisticsResult(String daily) {
        return this.queryStatistics.getStatisticsResult(daily);
    }

    DailyQueryStatistics getQueryStatistics() {
        return this.queryStatistics;
    }

    public Connection take() throws SQLException {
        try {
            PooledConnection connection = (PooledConnection)this.objectPool.borrowObject(this.maxWaitTime);
            connection.setValid(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ThreadUtils.currentThreadName() + " take connection " + connection.toString()));
            }
            return connection.getProxyConnection();
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    public void giveback(PooledConnection connection) throws SQLException {
        try {
            this.objectPool.givebackObject(connection);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ThreadUtils.currentThreadName() + " giveback connection " + connection.toString()));
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage(), e);
        }
    }

    public void close() throws SQLException {
        try {
            this.objectPool.close();
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}

