/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.date.DateUtils;
import com.github.paganini2008.devtools.objectpool.dbpool.QuerySpan;
import com.github.paganini2008.devtools.objectpool.dbpool.QuerySpanImpl;
import com.github.paganini2008.devtools.objectpool.dbpool.QueryTraceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DailyQueryStatistics {
    public static final String timeFormat = "dd/MM/yyyy";
    private final LruMap<String, ConcurrentMap<String, QuerySpan>> dailyStatistics = new LruMap(7);
    private int statisticalSqlSampleCount = 60;
    private long acceptableExecutionTime = 1000L;

    public Map<String, QuerySpan> getStatisticsResult(String daily) {
        return this.dailyStatistics.containsKey((Object)daily) ? new HashMap((Map)this.dailyStatistics.get((Object)daily)) : null;
    }

    public void setStatisticalSqlSampleCount(int statisticalSqlSampleCount) {
        this.statisticalSqlSampleCount = statisticalSqlSampleCount;
    }

    public void setAcceptableExecutionTime(long acceptableExecutionTime) {
        this.acceptableExecutionTime = acceptableExecutionTime;
    }

    public QuerySpan executed(String sql, Object[] parameters, long startTime, long endTime) {
        QuerySpan qs;
        String daily = DateUtils.format((Long)endTime, (String)timeFormat);
        ConcurrentMap data = (ConcurrentMap)this.dailyStatistics.get((Object)daily);
        if (data == null) {
            this.dailyStatistics.put((Object)daily, new ConcurrentHashMap());
            data = (ConcurrentMap)this.dailyStatistics.get((Object)daily);
        }
        if ((qs = (QuerySpan)data.get(sql)) == null) {
            data.putIfAbsent(sql, new QuerySpanImpl(this.statisticalSqlSampleCount, this.acceptableExecutionTime));
            qs = (QuerySpan)data.get(sql);
        }
        qs.record(new QueryTraceImpl(sql, parameters, startTime, endTime));
        return qs;
    }
}

