/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.objectpool.dbpool.ConnectionPool;
import com.github.paganini2008.devtools.objectpool.dbpool.ExceptionUtils;
import com.github.paganini2008.devtools.objectpool.dbpool.PooledPreparedStatement;
import com.github.paganini2008.devtools.objectpool.dbpool.PreparedStatementCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

public class PooledConnection
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(PooledConnection.class);
    private static final String CLOSE = "close";
    private static final Class<?>[] IFACES = new Class[]{Connection.class};
    private final ConnectionPool connectionPool;
    private final Connection realConnection;
    private final Connection proxyConnection;
    private volatile boolean valid;
    private final PreparedStatementCache statementCache;

    PooledConnection(Connection connection, int statementCacheSize, ConnectionPool connectionPool) {
        this.realConnection = connection;
        this.connectionPool = connectionPool;
        this.proxyConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), IFACES, (InvocationHandler)this);
        this.statementCache = new PreparedStatementCache(statementCacheSize, connectionPool.getQueryStatistics());
    }

    public void close() {
        if (this.isOpened()) {
            this.statementCache.destroy();
            JdbcUtils.closeQuietly((Connection)this.realConnection);
        }
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isOpened() {
        try {
            return !this.realConnection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public Connection getRealConnection() {
        return this.realConnection;
    }

    public Connection getProxyConnection() {
        return this.proxyConnection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            return this.realConnection == args[0];
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(this.realConnection);
        }
        if (methodName.equals("toString")) {
            return this.realConnection.toString();
        }
        if (methodName.equals("prepareStatement")) {
            String sql = (String)args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("[{}]Execute sql: {}", new Object[]{this.statementCache.size(), sql});
            }
            PooledPreparedStatement pps = this.statementCache.take(sql, this.realConnection, method, args);
            return pps.getProxyStatement();
        }
        if (CLOSE.equals(methodName)) {
            try {
                this.connectionPool.giveback(this);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.valid = false;
            return null;
        }
        if (!this.valid) {
            throw new SQLException("Connection is closed or unavailable now.");
        }
        try {
            return method.invoke((Object)this.realConnection, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.unwrapThrowable(t);
        }
    }
}

