/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.collection.LruSet;
import com.github.paganini2008.devtools.objectpool.dbpool.QuerySpan;
import com.github.paganini2008.devtools.objectpool.dbpool.QueryTrace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;

public class QuerySpanImpl
implements QuerySpan,
Serializable {
    private static final long serialVersionUID = 3318269140121500179L;
    private final LruSet<QueryTrace> slowQueries;
    private final long acceptableExecutionTime;
    private final AtomicLong executionTotalCount = new AtomicLong(0L);
    private final AtomicLong executionTotalTime = new AtomicLong(0L);
    private final AtomicLong executionMaxTime = new AtomicLong(0L);
    private final AtomicLong executionMinTime = new AtomicLong(Long.MAX_VALUE);

    public QuerySpanImpl(int maxSize, long acceptableExecutionTime) {
        this.slowQueries = new LruSet(new TreeSet(), maxSize);
        this.acceptableExecutionTime = acceptableExecutionTime;
    }

    @Override
    public void record(QueryTrace queryTrace) {
        long time = queryTrace.getEndTime() - queryTrace.getStartTime();
        this.executionTotalCount.incrementAndGet();
        this.executionTotalTime.addAndGet(time);
        long minTime = this.executionMinTime.get();
        this.executionMinTime.getAndSet(Math.min(minTime, time));
        long maxTime = this.executionMaxTime.get();
        this.executionMaxTime.getAndSet(Math.max(maxTime, time));
        if (time > this.acceptableExecutionTime) {
            this.slowQueries.add((Object)queryTrace);
        }
    }

    @Override
    public List<QueryTrace> getQueryTraces() {
        return new ArrayList<QueryTrace>((Collection<QueryTrace>)this.slowQueries);
    }

    @Override
    public long getExecutionCount() {
        return this.executionTotalCount.get();
    }

    @Override
    public long getExecutionAvgTime() {
        return this.executionTotalTime.get() / this.getExecutionCount();
    }

    @Override
    public long getExecutionMaxTime() {
        return this.executionMaxTime.get();
    }

    @Override
    public long getExecutionMinTime() {
        return this.executionMinTime.get();
    }

    public String toString() {
        return "QuerySpan [executionCount=" + this.getExecutionCount() + ", executionAvgTime=" + this.getExecutionAvgTime() + ", executionMaxTime=" + this.getExecutionMaxTime() + ", executionMinTime=" + this.getExecutionMinTime() + ", slowQueries: " + this.slowQueries.size() + "]";
    }
}

