/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.examples;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.objectpool.GenericObjectPool;
import com.github.paganini2008.devtools.objectpool.ObjectFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class TestObjectPool {
    public static void main(String[] args) throws Exception {
        GenericObjectPool objectPool = new GenericObjectPool(new ResourceFactory());
        objectPool.setMaxPoolSize(10);
        objectPool.setMaxIdleSize(3);
        ExecutorService executor = Executors.newFixedThreadPool(50);
        AtomicInteger score = new AtomicInteger();
        ArrayList errors = new ArrayList();
        Iterator iterator = Sequence.forEach((int)0, (int)10000).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            executor.execute(() -> {
                score.incrementAndGet();
                Resource resource = null;
                try {
                    resource = (Resource)objectPool.borrowObject();
                    System.out.println(resource.say(i) + " :: busySize: " + objectPool.getBusySize() + ", idleSize: " + objectPool.getIdleSize());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.add(e);
                }
                finally {
                    try {
                        objectPool.givebackObject(resource);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        System.in.read();
        System.out.println(score);
        objectPool.close();
        ExecutorUtils.gracefulShutdown((Executor)executor, (long)60000L);
        if (errors.size() > 0) {
            System.out.println(errors);
        }
        System.out.println("TestMain.main()");
    }

    public static class ResourceFactory
    implements ObjectFactory {
        private static final AtomicInteger seq = new AtomicInteger(0);

        @Override
        public Object createObject() throws Exception {
            return new Resource(seq.incrementAndGet());
        }

        @Override
        public void destroyObject(Object o) throws Exception {
            System.out.println("Destory: " + o);
        }
    }

    public static class Resource {
        private final int id;

        public Resource(int id) {
            this.id = id;
        }

        public String say(int i) {
            return ThreadUtils.currentThreadName() + ", Hello: " + i;
        }

        public String toString() {
            return "Resource: " + this.id;
        }
    }
}

