/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.objectpool.dbpool.DailyQueryStatistics;
import com.github.paganini2008.devtools.objectpool.dbpool.PooledPreparedStatement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public class PreparedStatementCache {
    private final LruMap<String, PooledPreparedStatement> cache;
    private final DailyQueryStatistics queryStatistics;

    public PreparedStatementCache(int maxSize, DailyQueryStatistics queryStatistics) {
        this.cache = new LruMap<String, PooledPreparedStatement>(maxSize){
            private static final long serialVersionUID = 847425849826360635L;

            public void onEviction(String eldestKey, PooledPreparedStatement ps) {
                ps.close();
            }
        };
        this.queryStatistics = queryStatistics;
    }

    public void destroy() {
        for (Map.Entry entry : this.cache.entrySet()) {
            ((PooledPreparedStatement)entry.getValue()).close();
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void giveback(String sql, PooledPreparedStatement pps) throws SQLException {
        if (pps.isOpened()) {
            this.cache.put((Object)sql, (Object)pps);
        }
    }

    public PooledPreparedStatement take(String sql, Connection connection, Method method, Object[] args) throws SQLException {
        PooledPreparedStatement instance = (PooledPreparedStatement)this.cache.remove((Object)sql);
        if (instance == null || !instance.isOpened()) {
            this.cache.put((Object)sql, (Object)this.createObject(sql, connection, method, args));
            instance = (PooledPreparedStatement)this.cache.get((Object)sql);
            instance.setQueryStatistics(this.queryStatistics);
        }
        instance.getRealStatement().clearWarnings();
        instance.getRealStatement().clearParameters();
        instance.getRealStatement().clearBatch();
        return instance;
    }

    protected PooledPreparedStatement createObject(String sql, Connection connection, Method method, Object[] args) throws SQLException {
        try {
            return new PooledPreparedStatement(sql, this, (PreparedStatement)method.invoke((Object)connection, args));
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof SQLException) {
                throw (SQLException)e.getTargetException();
            }
            throw new IllegalStateException(e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

