/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.examples;

import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.collection.Tuple;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.objectpool.dbpool.GenericDataSource;
import com.github.paganini2008.devtools.objectpool.dbpool.QuerySpan;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TestDataSource {
    public static void main(String[] args) throws Exception {
        GenericDataSource dataSource = new GenericDataSource();
        dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
        dataSource.setJdbcUrl("jdbc:mysql://localhost:3306/db_mec_hlsh_v2?userUnicode=true&characterEncoding=UTF8&useSSL=false&serverTimezone=UTC&autoReconnect=true&zeroDateTimeBehavior=convertToNull");
        dataSource.setUser("fengy");
        dataSource.setPassword("123456");
        ExecutorService executor = Executors.newFixedThreadPool(10);
        Iterator iterator = Sequence.forEach((int)0, (int)10000).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            executor.execute(() -> {
                Connection connection = null;
                Tuple tuple = null;
                try {
                    connection = dataSource.getConnection();
                    tuple = JdbcUtils.fetchOne((Connection)connection, (String)"select * from mec_area where level=? limit 1", (Object[])new Object[]{RandomUtils.randomInt((int)1, (int)4)});
                    System.out.println(tuple);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
            });
        }
        System.in.read();
        Map<String, QuerySpan> results = dataSource.getStatisticsResult("dd/MM/yyyy");
        System.out.println(results);
        dataSource.close();
        ExecutorUtils.gracefulShutdown((Executor)executor, (long)60000L);
        System.out.println("TestDataSource.main()");
    }

    static {
        System.setProperty("devtools.logging.com.github.paganini2008.devtools.objectpool", "debug");
    }
}

