/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.objectpool.ObjectFactory;
import com.github.paganini2008.devtools.objectpool.dbpool.ConnectionPool;
import com.github.paganini2008.devtools.objectpool.dbpool.PooledConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ConnectionObjectFactory
implements ObjectFactory {
    private String user;
    private String password;
    private String driverClassName;
    private String jdbcUrl;
    private String testSql;
    private Boolean autoCommit;
    private Integer defaultTransactionIsolationLevel;
    private Integer statementCacheSize = 32;
    private ExecutorService executor = Executors.newFixedThreadPool(8);
    private final ConnectionPool connectionPool;

    public ConnectionObjectFactory(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setStatementCacheSize(Integer statementCacheSize) {
        this.statementCacheSize = statementCacheSize;
    }

    public Integer getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public Integer getDefaultTransactionIsolationLevel() {
        return this.defaultTransactionIsolationLevel;
    }

    public void setDefaultTransactionIsolationLevel(Integer defaultTransactionIsolationLevel) {
        this.defaultTransactionIsolationLevel = defaultTransactionIsolationLevel;
    }

    public String getTestSql() {
        return this.testSql;
    }

    public void setTestSql(String testSql) {
        this.testSql = testSql;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid DriverClassName: " + driverClassName, e);
        }
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    protected void configureConnection(Connection connection) throws SQLException {
        if (this.autoCommit != null && connection.getAutoCommit() != this.autoCommit.booleanValue()) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (this.defaultTransactionIsolationLevel != null) {
            connection.setTransactionIsolation(this.defaultTransactionIsolationLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSql(Connection connection, String testSql) throws SQLException {
        Statement sm = null;
        try {
            sm = connection.createStatement();
            sm.executeQuery(testSql);
        }
        finally {
            JdbcUtils.closeQuietly((Statement)sm);
        }
    }

    @Override
    public PooledConnection createObject() throws SQLException {
        Connection connection = DriverManager.getConnection(this.jdbcUrl, this.user, this.password);
        this.configureConnection(connection);
        return new PooledConnection(connection, this.statementCacheSize, this.executor, this.connectionPool);
    }

    public boolean validateObject(Object connection) throws SQLException {
        boolean result;
        boolean bl = result = connection != null && ((PooledConnection)connection).isOpened();
        if (StringUtils.isNotBlank((CharSequence)this.testSql)) {
            this.testSql(((PooledConnection)connection).getRealConnection(), this.testSql);
        }
        return result;
    }

    @Override
    public void destroyObject(Object connection) throws SQLException {
        ((PooledConnection)connection).close();
    }
}

