/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.objectpool.dbpool.DailyQueryStatistics;
import com.github.paganini2008.devtools.objectpool.dbpool.PreparedStatementCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class PooledPreparedStatement
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(PooledPreparedStatement.class);
    private static final String CLOSE_METHOD = "close";
    private static final Class<?>[] IFACES = new Class[]{PreparedStatement.class};
    private final String sql;
    private final PreparedStatementCache statementCache;
    private PreparedStatement realStatement;
    private PreparedStatement proxyStatement;
    private DailyQueryStatistics queryStatistics;

    public PooledPreparedStatement(String sql, PreparedStatementCache statementCache, PreparedStatement ps) {
        this.sql = sql;
        this.statementCache = statementCache;
        this.realStatement = ps;
        this.proxyStatement = (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), IFACES, (InvocationHandler)this);
    }

    public void setQueryStatistics(DailyQueryStatistics queryStatistics) {
        this.queryStatistics = queryStatistics;
    }

    public PreparedStatement getRealStatement() {
        return this.realStatement;
    }

    public PreparedStatement getProxyStatement() {
        return this.proxyStatement;
    }

    public boolean isOpened() {
        try {
            return !this.realStatement.isClosed();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void close() {
        JdbcUtils.closeQuietly((Statement)this.realStatement);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            return this.realStatement == args[0];
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(this.realStatement);
        }
        if (methodName.equals("toString")) {
            return this.realStatement.toString();
        }
        if (CLOSE_METHOD.equals(methodName)) {
            this.statementCache.giveback(this.sql, this);
            return null;
        }
        if (methodName.startsWith("set") && args[0] instanceof Integer) {
            if (logger.isDebugEnabled() && args.length >= 2) {
                int parameterIndex = (Integer)args[0];
                Object parameter = args[1];
                logger.debug("[{}] Invoke: {}, Parameter: {}", new Object[]{parameterIndex, methodName, parameter});
            }
            return method.invoke((Object)this.realStatement, args);
        }
        if (this.queryStatistics != null && methodName.startsWith("executeQuery")) {
            long start = System.currentTimeMillis();
            Object result = method.invoke((Object)this.realStatement, args);
            if (this.queryStatistics != null) {
                this.queryStatistics.executed(this.sql, args, start, System.currentTimeMillis());
            }
            return result;
        }
        return method.invoke((Object)this.realStatement, args);
    }
}

