/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool;

import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.objectpool.ObjectDetail;
import com.github.paganini2008.devtools.objectpool.ObjectFactory;
import com.github.paganini2008.devtools.objectpool.ObjectPool;
import com.github.paganini2008.devtools.objectpool.PooledObjectException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class Jdk14ObjectPool
implements ObjectPool {
    private static final Log log = LogFactory.getLog(ObjectPool.class);
    private final Object lock = new Object();
    private final LinkedList<Object> busyQueue = new LinkedList();
    private final LinkedList<Object> idleQueue = new LinkedList();
    private final IdentityHashMap<Object, PooledObject> pooledObjects = new IdentityHashMap();
    private int maxPoolSize = 8;
    private int minIdleSize = 1;
    private int maxIdleSize;
    private int maxUsage = -1;
    private long checkIdleSizeInterval = 60000L;
    private int maxTestTimes = 3;
    private volatile int poolSize;
    private boolean testWhileIdle;
    private long testWhileIdleInterval = 3000L;
    private boolean checkObjectExpired;
    private long checkObjectExpiredInterval = 60000L;
    private long maxWaitTimeForExpiration = 60000L;
    private volatile boolean running;
    private Timer timer = new Timer();
    private final ObjectFactory objectFactory;

    public Jdk14ObjectPool(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.running = true;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMaxIdleSize() {
        return this.maxIdleSize;
    }

    public int getMinIdleSize() {
        return this.minIdleSize;
    }

    public void setMinIdleSize(int minIdleSize) {
        this.minIdleSize = minIdleSize;
    }

    public int getIdleSize() {
        return this.idleQueue.size();
    }

    public int getBusySize() {
        return this.busyQueue.size();
    }

    public void setMaxIdleSize(int maxIdleSize) {
        if (maxIdleSize > 0) {
            this.maxIdleSize = maxIdleSize;
            this.timer.scheduleAtFixedRate((TimerTask)new CheckIdleSizeTask(), this.checkIdleSizeInterval, this.checkIdleSizeInterval);
        }
    }

    public long getCheckIdleSizeInterval() {
        return this.checkIdleSizeInterval;
    }

    public void setCheckIdleSizeInterval(long checkIdleSizeInterval) {
        this.checkIdleSizeInterval = checkIdleSizeInterval;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (testWhileIdle) {
            this.timer.scheduleAtFixedRate((TimerTask)new TestWhileIdleTask(), this.testWhileIdleInterval, this.testWhileIdleInterval);
        }
    }

    public long getTestWhileIdleInterval() {
        return this.testWhileIdleInterval;
    }

    public void setTestWhileIdleInterval(long testWhileIdleInterval) {
        this.testWhileIdleInterval = testWhileIdleInterval;
    }

    public boolean isCheckObjectExpired() {
        return this.checkObjectExpired;
    }

    public void setCheckObjectExpired(boolean checkObjectExpired) {
        this.checkObjectExpired = checkObjectExpired;
        if (checkObjectExpired) {
            this.timer.scheduleAtFixedRate((TimerTask)new CheckObjectExpiredTask(), this.checkObjectExpiredInterval, this.checkObjectExpiredInterval);
        }
    }

    public long getMaxWaitTimeForExpiration() {
        return this.maxWaitTimeForExpiration;
    }

    public void setMaxWaitTimeForExpiration(long maxWaitTimeForExpiration) {
        this.maxWaitTimeForExpiration = maxWaitTimeForExpiration;
    }

    public int getMaxTestTimes() {
        return this.maxTestTimes;
    }

    public void setMaxTestTimes(int maxTestTimes) {
        this.maxTestTimes = maxTestTimes;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getMaxUsage() {
        return this.maxUsage;
    }

    public void setMaxUsage(int maxUsage) {
        this.maxUsage = maxUsage;
    }

    public long getCheckObjectExpiredInterval() {
        return this.checkObjectExpiredInterval;
    }

    public void setCheckObjectExpiredInterval(long checkObjectExpiredInterval) {
        this.checkObjectExpiredInterval = checkObjectExpiredInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object borrowObject() throws Exception {
        while (this.running) {
            Object object = this.lock;
            synchronized (object) {
                Object availableObject = this.idleQueue.pollFirst();
                if (availableObject != null) {
                    return this.testWhileBorrow(availableObject);
                }
                if (this.poolSize < this.maxPoolSize) {
                    Object newObject = this.objectFactory.createObject();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create new object: " + newObject));
                    }
                    availableObject = this.testWhileBorrow(newObject);
                    this.busyQueue.add(availableObject);
                    ++this.poolSize;
                }
                if (availableObject != null) {
                    return availableObject;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException ignored) {
                    break;
                }
            }
        }
        throw new PooledObjectException("Can not borrow any object now.");
    }

    private Object testWhileIdle(Object object) {
        int i = 0;
        Exception cause = null;
        do {
            try {
                if (this.objectFactory.testObject(object)) {
                    PooledObject pooledObject = this.pooledObjects.get(object);
                    pooledObject.setLastTested(System.currentTimeMillis());
                    return object;
                }
            }
            catch (Exception e) {
                cause = e;
            }
        } while (i++ < this.maxTestTimes);
        throw new PooledObjectException("Can not borrow any object now.", cause);
    }

    private Object testWhileBorrow(Object object) {
        int i = 0;
        Exception cause = null;
        do {
            try {
                if (this.objectFactory.testObject(object)) {
                    PooledObject pooledObject = this.pooledObjects.get(object);
                    if (pooledObject == null) {
                        this.pooledObjects.put(object, PooledObject.of(object));
                        pooledObject = this.pooledObjects.get(object);
                    }
                    pooledObject.setLastBorrowed(System.currentTimeMillis());
                    pooledObject.setUsage(pooledObject.getUsage() + 1);
                    return object;
                }
            }
            catch (Exception e) {
                cause = e;
            }
        } while (i++ < this.maxTestTimes);
        throw new PooledObjectException("Can not borrow any object now.", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object borrowObject(long timeout) throws Exception {
        long begin = System.nanoTime();
        long m = timeout;
        long n = 0L;
        while (this.running) {
            Object object = this.lock;
            synchronized (object) {
                long elapsed;
                Object availableObject = this.idleQueue.pollFirst();
                if (availableObject != null) {
                    return this.testWhileBorrow(availableObject);
                }
                if (this.poolSize < this.maxPoolSize) {
                    Object newObject = this.objectFactory.createObject();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Create new object: " + newObject));
                    }
                    availableObject = this.testWhileBorrow(newObject);
                    this.busyQueue.add(availableObject);
                    ++this.poolSize;
                }
                if (availableObject != null) {
                    return availableObject;
                }
                if (m > 0L) {
                    try {
                        this.lock.wait(m, (int)n);
                    }
                    catch (InterruptedException ignored) {
                        break;
                    }
                    elapsed = System.nanoTime() - begin;
                    m -= elapsed / 1000000L;
                } else {
                    break;
                }
                n = elapsed % 1000000L;
            }
        }
        throw new PooledObjectException("Can not borrow any object now.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void givebackObject(Object object) throws Exception {
        Object object2 = this.lock;
        synchronized (object2) {
            PooledObject pooledObject = this.pooledObjects.get(object);
            if (pooledObject != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Giveback object: " + object));
                }
                if (pooledObject.getReturns() + 1 != pooledObject.getUsage()) {
                    throw new PooledObjectException("Do not giveback pooled object '" + object.getClass().getName() + "' repeatedly!");
                }
                object = pooledObject.getObject();
                if (pooledObject.getUsage() == this.maxUsage) {
                    this.discardObject(object);
                } else {
                    this.busyQueue.remove(object);
                    this.idleQueue.add(object);
                    pooledObject.setReturns(pooledObject.getReturns() + 1);
                    pooledObject.setLastReturned(System.currentTimeMillis());
                    this.lock.notifyAll();
                }
            } else {
                throw new PooledObjectException("Unpooled object!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardObject(Object object) throws Exception {
        Object object2 = this.lock;
        synchronized (object2) {
            PooledObject pooledObject = this.pooledObjects.remove(object);
            if (pooledObject != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroy object: " + object));
                }
                object = pooledObject.getObject();
                this.busyQueue.remove(object);
                this.idleQueue.remove(object);
                try {
                    this.objectFactory.destroyObject(object);
                }
                finally {
                    --this.poolSize;
                    this.lock.notifyAll();
                }
            }
        }
    }

    @Override
    public ObjectDetail getDetail(Object object) {
        return this.pooledObjects.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.running = false;
        this.timer.cancel();
        Object object = this.lock;
        synchronized (object) {
            while (!this.busyQueue.isEmpty()) {
                ThreadUtils.randomSleep((long)1000L);
            }
            while (!this.idleQueue.isEmpty()) {
                Object idleObject = this.idleQueue.pollLast();
                try {
                    this.objectFactory.destroyObject(idleObject);
                }
                catch (Exception e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
                this.pooledObjects.remove(idleObject);
                --this.poolSize;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    class CheckObjectExpiredTask
    extends TimerTask {
        CheckObjectExpiredTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Jdk14ObjectPool.this.lock;
            synchronized (object) {
                for (Object busyObject : Jdk14ObjectPool.this.busyQueue) {
                    PooledObject pooledObject = (PooledObject)Jdk14ObjectPool.this.pooledObjects.get(busyObject);
                    if (System.currentTimeMillis() - pooledObject.getLastBorrowed() <= Jdk14ObjectPool.this.maxWaitTimeForExpiration) continue;
                    try {
                        Jdk14ObjectPool.this.discardObject(busyObject);
                        log.warn((Object)("Discard expired object: " + busyObject));
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    class CheckIdleSizeTask
    extends TimerTask {
        CheckIdleSizeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Jdk14ObjectPool.this.lock;
            synchronized (object) {
                if (Jdk14ObjectPool.this.idleQueue.size() > Jdk14ObjectPool.this.maxIdleSize) {
                    int destroyedSize = Jdk14ObjectPool.this.idleQueue.size() - Jdk14ObjectPool.this.maxIdleSize;
                    for (int i = 0; i < destroyedSize; ++i) {
                        Object object2 = Jdk14ObjectPool.this.idleQueue.pollFirst();
                        try {
                            Jdk14ObjectPool.this.discardObject(object2);
                            log.warn((Object)("Discard redundant object: " + object2));
                            continue;
                        }
                        catch (Exception e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    class TestWhileIdleTask
    extends TimerTask {
        TestWhileIdleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Jdk14ObjectPool.this.lock;
            synchronized (object) {
                if (Jdk14ObjectPool.this.idleQueue.size() > Jdk14ObjectPool.this.minIdleSize) {
                    ArrayList invalidObjects = new ArrayList();
                    for (Object idleObject : Jdk14ObjectPool.this.idleQueue) {
                        try {
                            Jdk14ObjectPool.this.testWhileIdle(idleObject);
                        }
                        catch (Exception e) {
                            invalidObjects.add(idleObject);
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (invalidObjects.size() > 0) {
                        for (Object invalidObject : invalidObjects) {
                            try {
                                Jdk14ObjectPool.this.discardObject(invalidObject);
                                log.warn((Object)("Discard invalid object: " + invalidObject));
                            }
                            catch (Exception e) {
                                log.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    static class PooledObject
    implements ObjectDetail {
        private final long created = System.currentTimeMillis();
        private final Object object;
        private long lastBorrowed;
        private long lastReturned;
        private long lastTested;
        private int usage;
        private int returns;

        PooledObject(Object object) {
            this.object = object;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public long getLastBorrowed() {
            return this.lastBorrowed;
        }

        public void setLastBorrowed(long lastBorrowed) {
            this.lastBorrowed = lastBorrowed;
        }

        @Override
        public long getLastReturned() {
            return this.lastReturned;
        }

        public void setLastReturned(long lastReturned) {
            this.lastReturned = lastReturned;
        }

        @Override
        public long getLastTested() {
            return this.lastTested;
        }

        public void setLastTested(long lastTested) {
            this.lastTested = lastTested;
        }

        @Override
        public int getUsage() {
            return this.usage;
        }

        public void setUsage(int usage) {
            this.usage = usage;
        }

        public int getReturns() {
            return this.returns;
        }

        public void setReturns(int returns) {
            this.returns = returns;
        }

        public static PooledObject of(Object object) {
            return new PooledObject(object);
        }
    }
}

