/**
* Copyright 2017-2021 Fred Feng (paganini.fy@gmail.com)

* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package com.github.paganini2008.devtools.objectpool.dbpool;

import java.util.List;

/**
 * 
 * QuerySpan 
 *
 * @author Fred Feng
 * @since 2.0.1
 */
public interface QuerySpan {

	/**
	 * Record every execution
	 * 
	 * @param queryTrace
	 */
	void record(QueryTrace queryTrace);

	/**
	 * Get slow queries
	 * @return
	 */
	List<QueryTrace> getQueryTraces();

	/**
	 * Get executed total.
	 * 
	 * @return
	 */
	long getExecutionCount();

	/**
	 * Get avg elapsed time.
	 * 
	 * @return
	 */
	float getExecutionAvgTime();

	/**
	 * Get max elapsed time.
	 * 
	 * @return
	 */
	long getExecutionMaxTime();

	/**
	 * Get min elapsed time.
	 * 
	 * @return
	 */
	long getExecutionMinTime();

}