/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.dbpool;

import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import com.github.paganini2008.devtools.objectpool.dbpool.ConnectionPool;
import com.github.paganini2008.devtools.objectpool.dbpool.PooledPreparedStatement;
import com.github.paganini2008.devtools.objectpool.dbpool.PreparedStatementCache;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PooledConnection
implements InvocationHandler {
    private static final Log logger = LogFactory.getLog(PooledConnection.class);
    private static final String CLOSE_METHOD = "close";
    private static final Class<?>[] IFACES = new Class[]{Connection.class};
    private final ConnectionPool connectionPool;
    private final Connection realConnection;
    private final Connection proxyConnection;
    private volatile boolean valid;
    private final PreparedStatementCache statementCache;
    private final ExecutorService executor;

    PooledConnection(Connection connection, int statementCacheSize, ExecutorService executor, ConnectionPool connectionPool) {
        this.realConnection = connection;
        this.executor = executor;
        this.connectionPool = connectionPool;
        this.proxyConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), IFACES, (InvocationHandler)this);
        this.statementCache = new PreparedStatementCache(statementCacheSize, connectionPool.getQueryStatistics());
    }

    public void close() {
        if (this.isOpened()) {
            this.statementCache.destroy();
            JdbcUtils.closeQuietly((Connection)this.realConnection);
        }
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isOpened() {
        try {
            return !this.realConnection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public Connection getRealConnection() {
        return this.realConnection;
    }

    public Connection getProxyConnection() {
        return this.proxyConnection;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            return this.realConnection == args[0];
        }
        if (methodName.equals("hashCode")) {
            return System.identityHashCode(this.realConnection);
        }
        if (methodName.equals("toString")) {
            return this.realConnection.toString();
        }
        if (methodName.equals("prepareStatement")) {
            String sql = (String)args[0];
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] Execute sql: {}", new Object[]{this.statementCache.size(), sql});
            }
            PooledPreparedStatement pps = this.statementCache.take(sql, this.realConnection, method, args);
            return pps.getProxyStatement();
        }
        if (CLOSE_METHOD.equals(methodName)) {
            this.valid = false;
            try {
                this.connectionPool.giveback(this);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
        if (!this.valid) {
            throw new SQLException("Connection is closed or unaccessable now.");
        }
        try {
            if (this.executor != null) {
                return this.executeAsynchronously(method, args);
            }
            return method.invoke((Object)this.realConnection, args);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (!(e instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw e;
        }
    }

    private Object executeAsynchronously(Method method, Object[] args) throws Throwable {
        Future<Object> future = this.executor.submit(() -> method.invoke((Object)this.realConnection, args));
        try {
            return future.get(this.connectionPool.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                this.getProxyConnection().close();
                throw new SQLException("Connection timeout!", e);
            }
            if (!(e instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw e;
        }
    }
}

