/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.objectpool.examples;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.objectpool.GenericObjectPool;
import com.github.paganini2008.devtools.objectpool.ObjectFactory;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class TestJdk14ObjectPool {
    public static void main(String[] args) throws Exception {
        GenericObjectPool objectPool = new GenericObjectPool(new ResourceFactory());
        objectPool.setMaxPoolSize(10);
        objectPool.setMaxIdleSize(3);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        AtomicInteger counter = new AtomicInteger();
        Iterator iterator = Sequence.forEach((int)0, (int)10000).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            executor.execute(() -> {
                counter.incrementAndGet();
                Resource resource = null;
                try {
                    resource = (Resource)objectPool.borrowObject();
                    ThreadUtils.randomSleep((long)1000L);
                    System.out.println(resource.doSomething(i) + " :: busySize: " + objectPool.getBusySize() + ", idleSize: " + objectPool.getIdleSize());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        objectPool.givebackObject(resource);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        System.in.read();
        System.out.println(counter);
        objectPool.close();
        ExecutorUtils.gracefulShutdown((Executor)executor, (long)60000L);
        System.out.println("Done.");
    }

    public static class ResourceFactory
    implements ObjectFactory {
        private static final AtomicInteger seq = new AtomicInteger(0);

        @Override
        public Object createObject() throws Exception {
            return new Resource(seq.incrementAndGet());
        }

        @Override
        public void destroyObject(Object o) throws Exception {
            System.out.println("Destory: " + o);
        }
    }

    public static class Resource {
        private final int id;

        public Resource(int id) {
            this.id = id;
        }

        public String doSomething(int i) {
            return ThreadUtils.currentThreadName() + " do something: " + i;
        }

        public String toString() {
            return "ID: " + this.id;
        }
    }
}

