/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx.functions;

import io.reactivesprint.Preconditions;
import rx.functions.Func1;

public abstract class BooleanFunc1<T>
implements Func1<T, Boolean> {
    public static <T> BooleanFunc1<T> from(Func1<T, Boolean> originalFunction) {
        return new Func1BooleanFromFunc1<T>((Func1)originalFunction){

            public Boolean call(T t) {
                return (Boolean)this.getOriginalFunction().call(t);
            }
        };
    }

    public BooleanFunc1<T> not() {
        return new Func1BooleanFromFunc1<T>(this){

            public Boolean call(T t) {
                return (Boolean)this.getOriginalFunction().call(t) == false;
            }
        };
    }

    public BooleanFunc1<T> and(final boolean value) {
        return new Func1BooleanFromFunc1<T>(this){

            public Boolean call(T t) {
                return value && (Boolean)this.getOriginalFunction().call(t) != false;
            }
        };
    }

    public BooleanFunc1<T> and(final Func1<T, Boolean> func1) {
        return new Func1BooleanFromFunc1<T>(this){

            public Boolean call(T t) {
                return (Boolean)func1.call(t) != false && (Boolean)this.getOriginalFunction().call(t) != false;
            }
        };
    }

    public BooleanFunc1<T> or(final boolean value) {
        return new Func1BooleanFromFunc1<T>(this){

            public Boolean call(T t) {
                return value || (Boolean)this.getOriginalFunction().call(t) != false;
            }
        };
    }

    public BooleanFunc1<T> or(final Func1<T, Boolean> func1) {
        return new Func1BooleanFromFunc1<T>(this){

            public Boolean call(T t) {
                return (Boolean)func1.call(t) != false || (Boolean)this.getOriginalFunction().call(t) != false;
            }
        };
    }

    private static abstract class Func1BooleanFromFunc1<T>
    extends BooleanFunc1<T> {
        private final Func1<T, Boolean> originalFunction;

        protected Func1BooleanFromFunc1(Func1<T, Boolean> originalFunction) {
            Preconditions.checkNotNull(originalFunction, "originalFunction");
            this.originalFunction = originalFunction;
        }

        public Func1<T, Boolean> getOriginalFunction() {
            return this.originalFunction;
        }
    }
}

