/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.viewmodels;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.ConstantProperty;
import io.reactivesprint.rx.IMutableProperty;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.viewmodels.IArrayViewModel;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.viewmodels.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayViewModel<E extends IViewModel>
extends ViewModel
implements IArrayViewModel<E>,
RandomAccess {
    private IProperty<Integer> count;
    private IProperty<Boolean> empty;
    private List<E> viewModels;
    private IMutableProperty<CharSequence> localizedEmptyMessage = new MutableProperty<Object>(null);

    protected ArrayViewModel() {
    }

    public ArrayViewModel(Collection<E> viewModels) {
        Preconditions.checkNotNull(viewModels, "viewModels");
        this.setViewModels(viewModels);
    }

    public ArrayViewModel(Collection<E> viewModels, String title) {
        this(viewModels);
        this.getTitle().setValue(title);
    }

    public ArrayViewModel(Collection<E> viewModels, String title, String localizedEmptyMessage) {
        this(viewModels);
        this.getTitle().setValue(title);
        this.getLocalizedEmptyMessage().setValue(localizedEmptyMessage);
    }

    @Override
    public Iterator<E> iterator() {
        return this.viewModels.iterator();
    }

    @Override
    public IProperty<Integer> getCount() {
        return this.count;
    }

    @Override
    public IProperty<Boolean> isEmpty() {
        return this.empty;
    }

    public IMutableProperty<CharSequence> getLocalizedEmptyMessage() {
        return this.localizedEmptyMessage;
    }

    protected void setViewModels(Collection<E> viewModels) {
        if (this.viewModels != null) {
            throw new AssertionError((Object)"Cannot re-setViewModels.");
        }
        this.viewModels = new ArrayList<E>(viewModels);
        this.count = new ConstantProperty<Integer>(viewModels.size());
        this.empty = new ConstantProperty<Boolean>(viewModels.isEmpty());
    }

    @Override
    public List<E> getViewModels() {
        return this.viewModels;
    }

    @Override
    public int indexOf(E element) {
        Preconditions.checkNotNull(element, "element");
        return this.viewModels.indexOf(element);
    }

    @Override
    public E getViewModel(int index) {
        return (E)((IViewModel)this.viewModels.get(index));
    }
}

