/*
 * Decompiled with CFR 0.152.
 */
package edu.gvsu.cis.masl.channelAPI;

import edu.gvsu.cis.masl.channelAPI.ChannelListener;
import edu.gvsu.cis.masl.channelAPI.DefaultChannelListener;
import edu.gvsu.cis.masl.channelAPI.XHR;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelAPI {
    private String BASE_URL = "http://localhost:8888";
    private final String CHANNEL_URL = "/_ah/channel/";
    private final String PROD_TALK_URL = "https://talkgadget.google.com/talkgadget/";
    private String channelId;
    private String applicationKey;
    private String clientId;
    private int requestId;
    private String sessionId;
    private String SID;
    private long messageId = 1L;
    private ChannelListener channelListener = new DefaultChannelListener();
    private ReadyState readyState = ReadyState.CLOSED;
    private Integer TIMEOUT_MS = 500;
    private HttpClient httpClient = HttpClientBuilder.create().build();
    private Thread thPoll;

    public ChannelAPI() {
    }

    public ChannelAPI(String string, String string2, ChannelListener channelListener) throws IOException {
        this.BASE_URL = string;
        this.channelId = this.createChannel(string2);
        if (channelListener != null) {
            this.channelListener = channelListener;
        }
    }

    public void joinChannel(String string, String string2, ChannelListener channelListener) {
        this.clientId = null;
        this.BASE_URL = string;
        this.channelId = string2;
        this.applicationKey = this.channelId.substring(this.channelId.lastIndexOf("-") + 1);
        if (channelListener != null) {
            this.channelListener = channelListener;
        }
    }

    private String createChannel(String string) throws IOException {
        String string2 = "";
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(this.BASE_URL + "/token?c=" + string);
        try {
            XHR xHR = new XHR(closeableHttpClient.execute((HttpUriRequest)httpGet));
            System.out.println(xHR.getResponseText());
            JSONObject jSONObject = new JSONObject(xHR.getResponseText());
            this.applicationKey = jSONObject.getString("channelKey");
            string2 = jSONObject.getString("token");
        }
        catch (JSONException jSONException) {
            System.out.println("Error: Parsing JSON");
        }
        return string2;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void open() throws IOException, ChannelException {
        this.readyState = ReadyState.CONNECTING;
        if (this.BASE_URL.contains("localhost")) {
            this.connect(this.sendGet(this.getUrl("connect")));
        } else {
            this.initialize();
            this.fetchSid();
            this.connect();
            this.longPoll();
        }
    }

    private void reopen() {
        try {
            this.channelId = this.createChannel(this.applicationKey);
            this.clientId = null;
            this.requestId = 0;
            this.sessionId = null;
            this.SID = null;
            this.messageId = 1L;
            this.thPoll = null;
            this.open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ChannelException channelException) {
            this.channelListener.onError(500, channelException.getMessage());
        }
    }

    private void initialize() throws ChannelException {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("cn", (Object)RandomStringUtils.random((int)10, (boolean)true, (boolean)false));
            jSONObject.put("tp", (Object)"null");
            jSONObject.put("lpu", (Object)"https://talkgadget.google.com/talkgadget/xpc_blank");
            jSONObject.put("ppu", (Object)(this.BASE_URL + "/_ah/channel/" + "xpc_blank"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("token", this.channelId));
        arrayList.add(new BasicNameValuePair("xpc", jSONObject.toString()));
        String string = "https://talkgadget.google.com/talkgadget/d?" + URLEncodedUtils.format(arrayList, (String)"UTF-8");
        HttpGet httpGet = new HttpGet(string);
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() > 299) {
                throw new ChannelException("Initialize failed: " + httpResponse.getStatusLine());
            }
            String string2 = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
            ChannelAPI.consume(httpResponse.getEntity());
            Pattern pattern = Pattern.compile("chat\\.WcsDataClient\\(([^\\)]+)\\)", 10);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                pattern = Pattern.compile("\"([^\"]*?)\"[\\s,]*", 8);
                matcher = pattern.matcher(string3);
                for (int i = 0; i < 7; ++i) {
                    if (!matcher.find()) {
                        throw new ChannelException("Expected iteration #" + i + " to find something.");
                    }
                    if (i == 2) {
                        this.clientId = matcher.group(1);
                        continue;
                    }
                    if (i == 3) {
                        this.sessionId = matcher.group(1);
                        continue;
                    }
                    if (i != 6 || this.channelId.equals(matcher.group(1))) continue;
                    throw new ChannelException("Tokens do not match!");
                }
            }
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    private void fetchSid() throws ChannelException {
        String string = this.getBindString(new NameValuePair[]{new BasicNameValuePair("CVER", "1")});
        HttpPost httpPost = new HttpPost(string);
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("count", "0"));
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try (TalkMessageParser talkMessageParser = null;){
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            talkMessageParser = new TalkMessageParser(httpResponse);
            TalkMessage talkMessage = talkMessageParser.getMessage();
            TalkMessage.TalkMessageEntry talkMessageEntry = talkMessage.getEntries().get(0);
            talkMessageEntry = talkMessageEntry.getMessageValue().getEntries().get(1);
            List<TalkMessage.TalkMessageEntry> list = talkMessageEntry.getMessageValue().getEntries();
            if (!list.get(0).getStringValue().equals("c")) {
                throw new InvalidMessageException("Expected first value to be 'c', found: " + list.get(0).getStringValue());
            }
            this.SID = list.get(1).getStringValue();
        }
    }

    private void connect() throws ChannelException {
        String string = this.getBindString(new NameValuePair[]{new BasicNameValuePair("AID", Long.toString(this.messageId)), new BasicNameValuePair("CVER", "1")});
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("count", "1"));
        arrayList.add(new BasicNameValuePair("ofs", "0"));
        arrayList.add(new BasicNameValuePair("req0_m", "[\"connect-add-client\"]"));
        arrayList.add(new BasicNameValuePair("req0_c", this.clientId));
        arrayList.add(new BasicNameValuePair("req0__sc", "c"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(arrayList);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            ChannelAPI.consume(httpResponse.getEntity());
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new ChannelException(clientProtocolException);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        this.channelListener.onOpen();
    }

    private String getBindString(NameValuePair ... nameValuePairArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new BasicNameValuePair("token", this.channelId));
        arrayList.add(new BasicNameValuePair("gsessionid", this.sessionId));
        arrayList.add(new BasicNameValuePair("clid", this.clientId));
        arrayList.add(new BasicNameValuePair("prop", "data"));
        arrayList.add(new BasicNameValuePair("zx", RandomStringUtils.random((int)12, (boolean)true, (boolean)false)));
        arrayList.add(new BasicNameValuePair("t", "1"));
        if (this.SID != null && this.SID != "") {
            arrayList.add(new BasicNameValuePair("SID", this.SID));
        }
        for (int i = 0; i < nameValuePairArray.length; ++i) {
            arrayList.add(nameValuePairArray[i]);
        }
        arrayList.add(new BasicNameValuePair("RID", Integer.toString(this.requestId)));
        ++this.requestId;
        return "https://talkgadget.google.com/talkgadget/dch/bind?VER=8&" + URLEncodedUtils.format(arrayList, (String)"UTF-8");
    }

    private void longPoll() {
        if (this.thPoll != null) {
            return;
        }
        this.thPoll = new Thread(){

            private TalkMessageParser poll() {
                String string = ChannelAPI.this.getBindString(new NameValuePair[]{new BasicNameValuePair("CI", "0"), new BasicNameValuePair("AID", Long.toString(ChannelAPI.this.messageId)), new BasicNameValuePair("TYPE", "xmlhttp"), new BasicNameValuePair("RID", "rpc")});
                HttpGet httpGet = new HttpGet(string);
                HttpResponse httpResponse = null;
                try {
                    httpResponse = ChannelAPI.this.httpClient.execute((HttpUriRequest)httpGet);
                    return new TalkMessageParser(httpResponse);
                }
                catch (ClientProtocolException clientProtocolException) {
                }
                catch (IOException iOException) {
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void run() {
                TalkMessageParser talkMessageParser = null;
                int n = 0;
                talkMessageParser = this.poll();
                while (ChannelAPI.this.readyState.equals((Object)ReadyState.OPEN)) {
                    if (talkMessageParser == null) {
                        if (n < 3) {
                            try {
                                Thread.sleep(2500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            talkMessageParser = this.poll();
                            ++n;
                            continue;
                        }
                        ChannelAPI.this.channelListener.onError(500, "Parser poll failed " + String.valueOf(n) + " times in a row!");
                        return;
                    }
                    n = 0;
                    try {
                        TalkMessage talkMessage = talkMessageParser.getMessage();
                        if (talkMessage == null) {
                            talkMessageParser.close();
                            talkMessageParser = null;
                            continue;
                        }
                        ChannelAPI.this.handleMessage(talkMessage);
                    }
                    catch (ChannelException channelException) {
                        ChannelAPI.this.reopen();
                        break;
                    }
                }
            }
        };
        this.readyState = ReadyState.OPEN;
        this.thPoll.setDaemon(true);
        this.thPoll.start();
    }

    private void handleMessage(TalkMessage talkMessage) {
        try {
            List<TalkMessage.TalkMessageEntry> list = talkMessage.getEntries();
            talkMessage = list.get(0).getMessageValue();
            list = talkMessage.getEntries();
            this.messageId = list.get(0).getNumberValue();
            talkMessage = list.get(1).getMessageValue();
            list = talkMessage.getEntries();
            if (list.get(0).getKind() == TalkMessage.MessageEntryKind.ME_STRING && list.get(0).getStringValue().equals("c")) {
                talkMessage = list.get(1).getMessageValue();
                String string = (list = talkMessage.getEntries()).get(0).getStringValue();
                if (!string.equals(this.sessionId)) {
                    this.sessionId = string;
                }
                if ((list = (talkMessage = list.get(1).getMessageValue()).getEntries()).get(0).getStringValue().equalsIgnoreCase("ae")) {
                    String string2 = list.get(1).getStringValue();
                    this.channelListener.onMessage(string2);
                }
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            invalidMessageException.printStackTrace();
        }
    }

    public void close() throws IOException {
        this.readyState = ReadyState.CLOSING;
        this.disconnect(this.sendGet(this.getUrl("disconnect")));
    }

    private static void consume(HttpEntity httpEntity) {
        try {
            if (httpEntity != null) {
                httpEntity.consumeContent();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getUrl(String string) throws IOException {
        String string2 = this.BASE_URL + "/_ah/channel/" + "dev?command=" + string + "&channel=";
        string2 = string2 + URLEncoder.encode(this.channelId, "UTF-8");
        if (this.clientId != null) {
            string2 = string2 + "&client=" + URLEncoder.encode(this.clientId, "UTF-8");
        }
        return string2;
    }

    private void connect(XHR xHR) {
        if (xHR.isSuccess()) {
            this.clientId = xHR.getResponseText();
            this.readyState = ReadyState.OPEN;
            this.channelListener.onOpen();
            this.poll();
        } else {
            this.readyState = ReadyState.CLOSING;
            this.channelListener.onError(xHR.getStatus(), xHR.getStatusText());
            this.readyState = ReadyState.CLOSED;
            this.channelListener.onClose();
        }
    }

    private void disconnect(XHR xHR) {
        this.readyState = ReadyState.CLOSED;
        this.channelListener.onClose();
    }

    private void forwardMessage(XHR xHR) {
        if (xHR.isSuccess()) {
            String string = StringUtils.chomp((String)xHR.getResponseText());
            if (!StringUtils.isEmpty((String)string)) {
                this.channelListener.onMessage(string);
            }
            this.poll();
        } else {
            this.channelListener.onError(xHR.getStatus(), xHR.getStatusText());
        }
    }

    private void poll() {
        if (this.thPoll == null) {
            this.thPoll = new Thread(){

                @Override
                public void run() {
                    XHR xHR = null;
                    try {
                        Thread.sleep(ChannelAPI.this.TIMEOUT_MS.intValue());
                        xHR = ChannelAPI.this.sendGet(ChannelAPI.this.getUrl("poll"));
                        ChannelAPI.this.thPoll = null;
                        ChannelAPI.this.forwardMessage(xHR);
                    }
                    catch (Exception exception) {
                        ChannelAPI.this.thPoll = null;
                    }
                }
            };
            this.thPoll.setDaemon(true);
            this.thPoll.start();
        }
    }

    private void forwardSendComplete(XHR xHR) {
        if (!xHR.isSuccess()) {
            this.channelListener.onError(xHR.getStatus(), xHR.getStatusText());
        }
    }

    public boolean send(String string, String string2) throws IOException {
        return this.send(string, this.applicationKey, string2);
    }

    public boolean send(String string, String string2, String string3) throws IOException {
        if (this.readyState != ReadyState.OPEN) {
            return false;
        }
        String string4 = this.BASE_URL + string3;
        ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
        arrayList.add((NameValuePair)new BasicNameValuePair("channelKey", string2));
        arrayList.add((NameValuePair)new BasicNameValuePair("message", string));
        this.forwardSendComplete(this.sendPost(string4, arrayList));
        return true;
    }

    private XHR sendPost(String string, List<NameValuePair> list) throws IOException {
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(list, "UTF-8");
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        return new XHR(closeableHttpClient.execute((HttpUriRequest)httpPost));
    }

    private XHR sendGet(String string) throws IOException {
        HttpGet httpGet = new HttpGet(string);
        return new XHR(this.httpClient.execute((HttpUriRequest)httpGet));
    }

    public void setChannelListener(ChannelListener channelListener) {
        if (channelListener != null) {
            this.channelListener = channelListener;
        }
    }

    public static class ChannelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ChannelException() {
        }

        public ChannelException(Throwable throwable) {
            super(throwable);
        }

        public ChannelException(String string) {
            super(string);
        }

        public ChannelException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class InvalidMessageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidMessageException(String string) {
            super(string);
        }

        public InvalidMessageException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class TalkMessage {
        private ArrayList<TalkMessageEntry> mEntries;

        public TalkMessage() {
            this.mEntries = new ArrayList();
        }

        private TalkMessage(ArrayList<TalkMessageEntry> arrayList) {
            this.mEntries = arrayList;
        }

        public List<TalkMessageEntry> getEntries() {
            return this.mEntries;
        }

        public void parse(BufferedReader bufferedReader) throws InvalidMessageException {
            try {
                if (TalkMessage.skipWhitespace(bufferedReader) != 91) {
                    throw new InvalidMessageException("Expected initial [");
                }
                this.mEntries = TalkMessage.parseMessage(bufferedReader);
            }
            catch (IOException iOException) {
                throw new InvalidMessageException(iOException);
            }
        }

        public String toString() {
            String string = "[";
            for (TalkMessageEntry talkMessageEntry : this.mEntries) {
                if (string != "[") {
                    string = string + ",";
                }
                string = string + talkMessageEntry.toString();
            }
            return string + "]";
        }

        private static ArrayList<TalkMessageEntry> parseMessage(BufferedReader bufferedReader) throws InvalidMessageException, IOException {
            ArrayList<TalkMessageEntry> arrayList = new ArrayList<TalkMessageEntry>();
            int n = TalkMessage.skipWhitespace(bufferedReader);
            while (n != 93) {
                if (n < 0) {
                    throw new InvalidMessageException("Unexpected end-of-message.");
                }
                if (n == 91) {
                    ArrayList<TalkMessageEntry> arrayList2 = TalkMessage.parseMessage(bufferedReader);
                    arrayList.add(new TalkMessageEntry(MessageEntryKind.ME_TALKMESSAGE, new TalkMessage(arrayList2)));
                } else if (n == 34 || n == 39) {
                    String string = TalkMessage.parseStringValue(bufferedReader, (char)n);
                    arrayList.add(new TalkMessageEntry(MessageEntryKind.ME_STRING, string));
                } else if (n == 44) {
                    arrayList.add(new TalkMessageEntry(MessageEntryKind.ME_EMPTY, null));
                } else if (n == 110 || n == 78) {
                    n = bufferedReader.read();
                    n = bufferedReader.read();
                    n = bufferedReader.read();
                    arrayList.add(new TalkMessageEntry(MessageEntryKind.ME_EMPTY, null));
                } else {
                    long l = TalkMessage.parseNumberValue(bufferedReader, (char)n);
                    arrayList.add(new TalkMessageEntry(MessageEntryKind.ME_NUMBER, l));
                }
                if (n != 44) {
                    n = TalkMessage.skipWhitespace(bufferedReader);
                }
                if (n != 44 && n != 93) {
                    throw new InvalidMessageException("Expected , or ], found " + (char)n);
                }
                if (n != 44) continue;
                n = TalkMessage.skipWhitespace(bufferedReader);
            }
            return arrayList;
        }

        private static String parseStringValue(BufferedReader bufferedReader, char c) throws IOException {
            String string = "";
            int n = bufferedReader.read();
            while (n > 0 && n != c && (n != 92 || (n = bufferedReader.read()) >= 0)) {
                string = string + (char)n;
                n = bufferedReader.read();
            }
            return string;
        }

        private static long parseNumberValue(BufferedReader bufferedReader, char n) throws IOException {
            String string = "";
            int n2 = n;
            while (n2 > 0 && Character.isDigit(n2)) {
                string = string + (char)n2;
                bufferedReader.mark(1);
                n2 = bufferedReader.read();
            }
            bufferedReader.reset();
            return Long.parseLong(string);
        }

        private static int skipWhitespace(BufferedReader bufferedReader) throws IOException {
            int n = bufferedReader.read();
            while (n >= 0) {
                if (!Character.isWhitespace(n)) {
                    return n;
                }
                n = bufferedReader.read();
            }
            return -1;
        }

        public static class TalkMessageEntry {
            MessageEntryKind mKind;
            Object mValue;

            public TalkMessageEntry(MessageEntryKind messageEntryKind, Object object) {
                this.mKind = messageEntryKind;
                this.mValue = object;
            }

            public MessageEntryKind getKind() {
                return this.mKind;
            }

            public String getStringValue() throws InvalidMessageException {
                if (this.mKind == MessageEntryKind.ME_STRING) {
                    return (String)this.mValue;
                }
                throw new InvalidMessageException("String value expected, found: " + (Object)((Object)this.mKind) + " (" + this.mValue + ")");
            }

            public long getNumberValue() throws InvalidMessageException {
                if (this.mKind == MessageEntryKind.ME_NUMBER) {
                    return (Long)this.mValue;
                }
                throw new InvalidMessageException("Number value expected, found: " + (Object)((Object)this.mKind) + " (" + this.mValue + ")");
            }

            public TalkMessage getMessageValue() throws InvalidMessageException {
                if (this.mKind == MessageEntryKind.ME_TALKMESSAGE) {
                    return (TalkMessage)this.mValue;
                }
                throw new InvalidMessageException("TalkMessage value expected, found: " + (Object)((Object)this.mKind) + " (" + this.mValue + ")");
            }

            public String toString() {
                if (this.mKind == MessageEntryKind.ME_EMPTY) {
                    return "";
                }
                if (this.mKind == MessageEntryKind.ME_STRING) {
                    return "\"" + this.mValue.toString() + "\"";
                }
                return this.mValue.toString();
            }
        }

        public static enum MessageEntryKind {
            ME_STRING,
            ME_NUMBER,
            ME_EMPTY,
            ME_TALKMESSAGE;

        }
    }

    private static class TalkMessageParser {
        private HttpResponse mHttpResponse;
        private BufferedReader mReader;

        public TalkMessageParser(HttpResponse httpResponse) throws ChannelException {
            try {
                this.mHttpResponse = httpResponse;
                InputStream inputStream = httpResponse.getEntity().getContent();
                this.mReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            catch (IllegalStateException illegalStateException) {
                throw new ChannelException(illegalStateException);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }

        public TalkMessage getMessage() throws ChannelException {
            String string = this.readSubmission();
            if (string == null) {
                return null;
            }
            TalkMessage talkMessage = new TalkMessage();
            try {
                talkMessage.parse(new BufferedReader(new StringReader(string)));
            }
            catch (InvalidMessageException invalidMessageException) {
                throw new ChannelException(invalidMessageException);
            }
            return talkMessage;
        }

        public void close() {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mHttpResponse != null) {
                ChannelAPI.consume(this.mHttpResponse.getEntity());
            }
        }

        private String readSubmission() throws ChannelException {
            try {
                int n;
                String string = this.mReader.readLine();
                if (string == null) {
                    return null;
                }
                int n2 = Integer.parseInt(string);
                char[] cArray = new char[n2];
                for (int i = 0; i < n2; i += n) {
                    n = this.mReader.read(cArray, i, n2 - i);
                }
                return new String(cArray);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ChannelException("Submission was not in expected format.", numberFormatException);
            }
        }
    }

    private static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

