/*
 * Decompiled with CFR 0.152.
 */
package edu.gvsu.cis.masl.channelAPI;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class XHR {
    private String responseText;
    private Integer status;
    private String statusText;

    public XHR(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpEntity httpEntity = httpResponse.getEntity();
        this.status = statusLine.getStatusCode();
        this.statusText = statusLine.getReasonPhrase();
        this.responseText = IOUtils.toString((InputStream)httpEntity.getContent(), (String)"UTF-8");
    }

    public String getStatusText() {
        return this.statusText;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return this.status == 200;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Status: ");
        stringBuffer.append(this.status);
        stringBuffer.append(", Error: ");
        stringBuffer.append(this.statusText);
        stringBuffer.append(", Message: ");
        stringBuffer.append(this.responseText);
        return stringBuffer.toString();
    }
}

