/*
 * Decompiled with CFR 0.152.
 */
package com.github.ryanp102694;

import com.github.ryanp102694.geometry.GeometryUtil;
import com.github.ryanp102694.geometry.RectangleObject;
import com.github.ryanp102694.geometry.SearchRectangleObject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QuadTree {
    protected static final int THIS_QUADTREE = -1;
    protected static final int NE_CHILD = 0;
    protected static final int NW_CHILD = 1;
    protected static final int SW_CHILD = 2;
    protected static final int SE_CHILD = 3;
    private int maxObjects = 10;
    private int maxLevels = 5;
    private int defaultWidth = 100;
    private int defaultHeight = 100;
    private QuadTree parent;
    private QuadTree[] children;
    private List<RectangleObject> rectangleObjects;
    private Integer level;
    private Integer x;
    private Integer y;
    private Integer w;
    private Integer h;

    public QuadTree() {
        this.level = 0;
        this.x = 0;
        this.y = 0;
        this.w = this.defaultWidth;
        this.h = this.defaultHeight;
        this.rectangleObjects = new ArrayList<RectangleObject>();
        this.parent = null;
        this.children = new QuadTree[4];
    }

    public QuadTree(int maxObjects, int maxLevels, int level, int x, int y, int w, int h, QuadTree parent) {
        this.maxObjects = maxObjects;
        this.maxLevels = maxLevels;
        this.level = level;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.rectangleObjects = new ArrayList<RectangleObject>();
        this.parent = parent;
        this.children = new QuadTree[4];
    }

    public void insert(RectangleObject rectangleObject) {
        int indexToPlaceObject;
        if (this.children[0] != null && (indexToPlaceObject = this.getChildIndexRectangleBelongsIn(rectangleObject)) != -1) {
            this.children[indexToPlaceObject].insert(rectangleObject);
            return;
        }
        this.rectangleObjects.add(rectangleObject);
        if (this.rectangleObjects.size() > this.maxObjects && this.level < this.maxLevels) {
            this.split();
            int i = 0;
            while (i < this.rectangleObjects.size()) {
                int indexToPlaceObject2 = this.getChildIndexRectangleBelongsIn(this.rectangleObjects.get(i));
                if (indexToPlaceObject2 != -1) {
                    this.children[indexToPlaceObject2].insert(this.rectangleObjects.remove(i));
                    continue;
                }
                ++i;
            }
        }
    }

    public RectangleObject remove(RectangleObject rectangleObject) {
        int index = this.getChildIndexRectangleBelongsIn(rectangleObject);
        if (index == -1 || this.children[index] == null) {
            for (int i = 0; i < this.rectangleObjects.size(); ++i) {
                if (!this.rectangleObjects.get(i).getId().equals(rectangleObject.getId())) continue;
                return this.rectangleObjects.remove(i);
            }
        } else {
            return this.children[index].remove(rectangleObject);
        }
        return null;
    }

    public void update(RectangleObject initialRectangleObject, RectangleObject updatedRectangleObject) {
        QuadTree quadTree = this;
        int index = quadTree.getChildIndexRectangleBelongsIn(initialRectangleObject);
        while (index != -1 && quadTree.children[index] != null) {
            quadTree = quadTree.children[index];
            index = quadTree.getChildIndexRectangleBelongsIn(initialRectangleObject);
        }
        for (int i = 0; i < quadTree.getRectangleObjects().size(); ++i) {
            if (!quadTree.getRectangleObjects().get(i).getId().equals(initialRectangleObject.getId())) continue;
            RectangleObject rectangleObjectToUpdate = quadTree.getRectangleObjects().remove(i);
            rectangleObjectToUpdate.setX(updatedRectangleObject.getX());
            rectangleObjectToUpdate.setY(updatedRectangleObject.getY());
            rectangleObjectToUpdate.setW(updatedRectangleObject.getW());
            rectangleObjectToUpdate.setH(updatedRectangleObject.getH());
            if (GeometryUtil.rectangleObjectIsInside(new SearchRectangleObject((double)quadTree.getX(), (double)quadTree.getY(), (double)quadTree.getW(), (double)quadTree.getH()), updatedRectangleObject).booleanValue()) {
                quadTree.insert(rectangleObjectToUpdate);
                break;
            }
            quadTree = quadTree.getParent();
            while (quadTree.getParent() != null && !GeometryUtil.rectangleObjectIsInside(new SearchRectangleObject((double)quadTree.getX(), (double)quadTree.getY(), (double)quadTree.getW(), (double)quadTree.getH()), rectangleObjectToUpdate).booleanValue()) {
                quadTree = quadTree.getParent();
            }
            if (!GeometryUtil.rectangleObjectIsInside(new SearchRectangleObject((double)quadTree.getX(), (double)quadTree.getY(), (double)quadTree.getW(), (double)quadTree.getH()), rectangleObjectToUpdate).booleanValue()) break;
            quadTree.insert(rectangleObjectToUpdate);
            break;
        }
    }

    public List<RectangleObject> search(RectangleObject rectangleObject) {
        ArrayList<RectangleObject> returnList = new ArrayList<RectangleObject>();
        ListIterator<RectangleObject> iterator = this.search(new ArrayList<RectangleObject>(), rectangleObject).listIterator();
        while (iterator.hasNext()) {
            RectangleObject currentRectangleObject = iterator.next();
            if (!GeometryUtil.rectangleObjectsOverlap(currentRectangleObject, rectangleObject).booleanValue()) continue;
            returnList.add(currentRectangleObject);
        }
        return returnList;
    }

    public Integer getDepth() {
        return 1 + Math.max(Math.max(this.children[0] == null ? 0 : this.children[0].getDepth(), this.children[1] == null ? 0 : this.children[1].getDepth()), Math.max(this.children[2] == null ? 0 : this.children[2].getDepth(), this.children[3] == null ? 0 : this.children[3].getDepth()));
    }

    public Integer getTotalObjects() {
        return this.rectangleObjects.size() + (this.children[0] == null ? 0 : this.children[0].getTotalObjects()) + (this.children[1] == null ? 0 : this.children[1].getTotalObjects()) + (this.children[2] == null ? 0 : this.children[2].getTotalObjects()) + (this.children[3] == null ? 0 : this.children[3].getTotalObjects());
    }

    public void clear() {
        this.rectangleObjects.clear();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            this.children[i].clear();
            this.children[i] = null;
        }
    }

    private List<RectangleObject> search(List<RectangleObject> rectangleObjects, RectangleObject rectangleObject) {
        rectangleObjects.addAll(this.rectangleObjects);
        int index = this.getChildIndexRectangleBelongsIn(rectangleObject);
        if (index == -1 || this.children[0] == null) {
            if (this.children[0] != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (!GeometryUtil.rectangleObjectsOverlap(new SearchRectangleObject((double)this.children[i].getX(), (double)this.children[i].getY(), (double)this.children[i].getW(), (double)this.children[i].getH()), rectangleObject).booleanValue()) continue;
                    this.children[i].search(rectangleObjects, rectangleObject);
                }
            }
        } else if (this.children[index] != null) {
            this.children[index].search(rectangleObjects, rectangleObject);
        }
        return rectangleObjects;
    }

    private void split() {
        int childWidth = this.w / 2;
        int childHeight = this.h / 2;
        this.children[0] = new QuadTree(this.maxObjects, this.maxLevels, this.level + 1, this.x + childWidth, this.y, childWidth, childHeight, this);
        this.children[1] = new QuadTree(this.maxObjects, this.maxLevels, this.level + 1, this.x, this.y, childWidth, childHeight, this);
        this.children[2] = new QuadTree(this.maxObjects, this.maxLevels, this.level + 1, this.x, this.y + childHeight, childWidth, childHeight, this);
        this.children[3] = new QuadTree(this.maxObjects, this.maxLevels, this.level + 1, this.x + childWidth, this.y + childHeight, childWidth, childHeight, this);
    }

    protected int getChildIndexRectangleBelongsIn(RectangleObject rectangleObject) {
        boolean fitsCompletelyInEastHalf;
        int index = -1;
        double verticalDividingLine = this.getX() + this.getW() / 2;
        double horizontalDividingLine = this.getY() + this.getH() / 2;
        boolean fitsCompletelyInNorthHalf = rectangleObject.getY() < horizontalDividingLine && rectangleObject.getH() + rectangleObject.getY() < horizontalDividingLine;
        boolean fitsCompletelyInSouthHalf = rectangleObject.getY() > horizontalDividingLine;
        boolean fitsCompletelyInWestHalf = rectangleObject.getX() < verticalDividingLine && rectangleObject.getX() + rectangleObject.getW() < verticalDividingLine;
        boolean bl = fitsCompletelyInEastHalf = rectangleObject.getX() > verticalDividingLine;
        if (fitsCompletelyInEastHalf) {
            if (fitsCompletelyInNorthHalf) {
                index = 0;
            } else if (fitsCompletelyInSouthHalf) {
                index = 3;
            }
        } else if (fitsCompletelyInWestHalf) {
            if (fitsCompletelyInNorthHalf) {
                index = 1;
            } else if (fitsCompletelyInSouthHalf) {
                index = 2;
            }
        }
        return index;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this.maxObjects = maxObjects;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public void setMaxLevels(int maxLevels) {
        this.maxLevels = maxLevels;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(int defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public List<RectangleObject> getRectangleObjects() {
        return this.rectangleObjects;
    }

    public void setRectangleObjects(List<RectangleObject> rectangleObjects) {
        this.rectangleObjects = rectangleObjects;
    }

    public void addRectangleObject(RectangleObject rectangleObject) {
        if (this.rectangleObjects == null) {
            this.rectangleObjects = new ArrayList<RectangleObject>();
        }
        this.rectangleObjects.add(rectangleObject);
    }

    public Integer getX() {
        return this.x;
    }

    public void setX(Integer x) {
        this.x = x;
    }

    public Integer getY() {
        return this.y;
    }

    public void setY(Integer y) {
        this.y = y;
    }

    public Integer getW() {
        return this.w;
    }

    public void setW(Integer w) {
        this.w = w;
    }

    public Integer getH() {
        return this.h;
    }

    public void setH(Integer h) {
        this.h = h;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public QuadTree getParent() {
        return this.parent;
    }

    public void setParent(QuadTree parent) {
        this.parent = parent;
    }

    public QuadTree[] getChildren() {
        return this.children;
    }

    public void setChildren(QuadTree[] children) {
        this.children = children;
    }
}

