/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.google;

import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Objects;

public class GoogleToken
extends OAuth2AccessToken {
    private static final long serialVersionUID = 7845679917727899612L;
    private final String openIdToken;

    public GoogleToken(String accessToken, String openIdToken, String rawResponse) {
        this(accessToken, null, null, null, null, openIdToken, rawResponse);
    }

    public GoogleToken(String accessToken, String tokenType, Integer expiresIn, String refreshToken, String scope, String openIdToken, String rawResponse) {
        super(accessToken, tokenType, expiresIn, refreshToken, scope, rawResponse);
        this.openIdToken = openIdToken;
    }

    public String getOpenIdToken() {
        return this.openIdToken;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.getAccessToken());
        hash = 37 * hash + Objects.hashCode(this.getTokenType());
        hash = 37 * hash + Objects.hashCode(this.getExpiresIn());
        hash = 37 * hash + Objects.hashCode(this.getRefreshToken());
        hash = 37 * hash + Objects.hashCode(this.getScope());
        hash = 37 * hash + Objects.hashCode(this.openIdToken);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GoogleToken other = (GoogleToken)((Object)obj);
        if (!Objects.equals(this.getAccessToken(), other.getAccessToken())) {
            return false;
        }
        if (!Objects.equals(this.getTokenType(), other.getTokenType())) {
            return false;
        }
        if (!Objects.equals(this.getRefreshToken(), other.getRefreshToken())) {
            return false;
        }
        if (!Objects.equals(this.getScope(), other.getScope())) {
            return false;
        }
        if (!Objects.equals(this.openIdToken, other.getOpenIdToken())) {
            return false;
        }
        return Objects.equals(this.getExpiresIn(), other.getExpiresIn());
    }

    public String toString() {
        return "GoogleToken{access_token=" + this.getAccessToken() + ", token_type=" + this.getTokenType() + ", expires_in=" + this.getExpiresIn() + ", refresh_token=" + this.getRefreshToken() + ", scope=" + this.getScope() + ", open_id_token=" + this.openIdToken + '}';
    }
}

