/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1RequestToken;

public class EtsyApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://www.etsy.com/oauth/signin?oauth_token=%s";
    private static final String ACCESS_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/access_token";
    private static final String REQUEST_TOKEN_URL = "https://openapi.etsy.com/v2/oauth/request_token";
    private final String scopeAsString;

    private EtsyApi() {
        this.scopeAsString = null;
    }

    private EtsyApi(String ... scopes) {
        StringBuilder builder = new StringBuilder();
        for (String scope : scopes) {
            builder.append("%20").append(scope);
        }
        this.scopeAsString = "?scope=" + builder.substring(3);
    }

    public static EtsyApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static EtsyApi instance(String ... scopes) {
        return scopes == null || scopes.length == 0 ? EtsyApi.instance() : new EtsyApi(scopes);
    }

    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    public String getRequestTokenEndpoint() {
        return this.scopeAsString == null ? REQUEST_TOKEN_URL : REQUEST_TOKEN_URL + this.scopeAsString;
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    private static class InstanceHolder {
        private static final EtsyApi INSTANCE = new EtsyApi();

        private InstanceHolder() {
        }
    }
}

