/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class OdnoklassnikiOAuthService
extends OAuth20Service {
    public OdnoklassnikiOAuthService(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        try {
            String tokenDigest = DigestUtils.md5Hex((String)(accessToken + this.getConfig().getApiSecret()));
            ParameterList queryParams = request.getQueryStringParams();
            queryParams.addAll(request.getBodyParams());
            List allParams = queryParams.getParams();
            Collections.sort(allParams);
            String stringParams = allParams.stream().map(param -> param.getKey() + '=' + param.getValue()).collect(Collectors.joining());
            String sigSource = URLDecoder.decode(stringParams, "UTF-8") + tokenDigest;
            request.addQuerystringParameter("sig", DigestUtils.md5Hex((String)sigSource).toLowerCase());
            super.signRequest(accessToken, request);
        }
        catch (UnsupportedEncodingException unex) {
            throw new IllegalStateException(unex);
        }
    }
}

