/*
 * Decompiled with CFR 0.152.
 */
package com.github.sjcasey21.wavefunctioncollapse;

import com.github.sjcasey21.wavefunctioncollapse.Model;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;

public class SimpleTiledModel
extends Model {
    List<Color[]> tiles;
    List<String> tilenames;
    int tilesize;
    boolean black;

    public SimpleTiledModel(int tilesize, List<HashMap<String, String>> tilesData, List<HashMap<String, String>> neighborsData, HashMap<String, String[]> subsetsData, HashMap<String, BufferedImage> tileData, String subsetName, int width, int height, boolean periodic, boolean black, boolean unique) {
        super(width, height);
        int d;
        this.periodic = periodic;
        this.black = black;
        this.tilesize = tilesize;
        List<Object> subset = null;
        if (subsetName != null && subsetsData != null && subsetsData.containsKey(subsetName)) {
            subset = Arrays.asList((Object[])subsetsData.get(subsetName));
        }
        Function<BiFunction, Color[]> tile = f -> {
            Color[] result = new Color[this.tilesize * this.tilesize];
            for (int y = 0; y < this.tilesize; ++y) {
                for (int x = 0; x < this.tilesize; ++x) {
                    result[x + y * tilesize] = (Color)f.apply(x, y);
                }
            }
            return result;
        };
        Function<Color[], Color[]> rotate = array -> (Color[])tile.apply((x, y) -> array[this.tilesize - 1 - y + x * this.tilesize]);
        this.tiles = new ArrayList<Color[]>();
        this.tilenames = new ArrayList<String>();
        ArrayList<Double> tempStationary = new ArrayList<Double>();
        ArrayList<Integer[]> action = new ArrayList<Integer[]>();
        HashMap<String, Integer> firstOccurrence = new HashMap<String, Integer>();
        for (HashMap<String, String> xtile : tilesData) {
            int t;
            Function<Integer, Integer> b;
            Function<Integer, Integer> a;
            int cardinality;
            String tilename = xtile.get("name");
            String sym = xtile.getOrDefault("symmetry", "X");
            if (subset != null && !subset.contains(tilename)) continue;
            switch (sym) {
                case "L": {
                    cardinality = 4;
                    a = i -> (i + 1) % 4;
                    b = i -> i % 2 == 0 ? i + 1 : i - 1;
                    break;
                }
                case "T": {
                    cardinality = 4;
                    a = i -> (i + 1) % 4;
                    b = i -> i % 2 == 0 ? i : 4 - i;
                    break;
                }
                case "I": {
                    cardinality = 2;
                    a = i -> 1 - i;
                    b = i -> i;
                    break;
                }
                case "\\": {
                    cardinality = 2;
                    a = i -> 1 - i;
                    b = i -> 1 - i;
                    break;
                }
                default: {
                    cardinality = 1;
                    a = i -> i;
                    b = i -> i;
                }
            }
            this.T = action.size();
            firstOccurrence.put(tilename, this.T);
            Integer[][] map = new Integer[cardinality][];
            for (t = 0; t < cardinality; ++t) {
                map[t] = new Integer[8];
                map[t][0] = t;
                map[t][1] = a.apply(t);
                map[t][2] = a.apply(a.apply(t));
                map[t][3] = a.apply(a.apply(a.apply(t)));
                map[t][4] = b.apply(t);
                map[t][5] = b.apply(a.apply(t));
                map[t][6] = b.apply(a.apply(a.apply(t)));
                map[t][7] = b.apply(a.apply(a.apply(a.apply(t))));
                int s = 0;
                while (s < 8) {
                    Integer[] integerArray = map[t];
                    int n = s++;
                    Integer.valueOf(integerArray[n] + this.T);
                }
                action.add(map[t]);
            }
            if (unique) {
                for (t = 0; t < cardinality; ++t) {
                    BufferedImage xtileData = tileData.get(tilename);
                    this.tiles.add(tile.apply((x, y) -> new Color(xtileData.getRGB((int)x, (int)y))));
                    this.tilenames.add(String.format("%s %s", tilename, t));
                }
            } else {
                BufferedImage xtileData = tileData.get(tilename);
                this.tiles.add(tile.apply((x, y) -> new Color(xtileData.getRGB((int)x, (int)y))));
                this.tilenames.add(String.format("%s 0", tilename));
                for (int t2 = 1; t2 < cardinality; ++t2) {
                    this.tiles.add(rotate.apply(this.tiles.get(this.T + t2 - 1)));
                    this.tilenames.add(String.format("%s %s", tilename, t2));
                }
            }
            for (t = 0; t < cardinality; ++t) {
                tempStationary.add(Double.valueOf(xtile.getOrDefault("weight", "1.0")));
            }
        }
        this.T = action.size();
        this.weights = tempStationary.toArray(new Double[0]);
        this.propagator = new int[4][][];
        boolean[][][] tempPropagator = new boolean[4][][];
        for (int d2 = 0; d2 < 4; ++d2) {
            tempPropagator[d2] = new boolean[this.T][];
            this.propagator[d2] = new int[this.T][];
            for (int t = 0; t < this.T; ++t) {
                tempPropagator[d2][t] = new boolean[this.T];
            }
        }
        for (HashMap<String, String> xneighbor : neighborsData) {
            String[] left = (String[])Arrays.stream(xneighbor.get("left").split(" ")).filter(x -> !x.isEmpty()).toArray(String[]::new);
            String[] right = (String[])Arrays.stream(xneighbor.get("right").split(" ")).filter(x -> !x.isEmpty()).toArray(String[]::new);
            if (subset != null && (!subset.contains(left[0]) || !subset.contains(right[0]))) continue;
            int L = ((Integer[])action.get((Integer)firstOccurrence.get(left[0])))[left.length == 1 ? 0 : Integer.valueOf(left[1])];
            int D = ((Integer[])action.get(L))[1];
            int R = ((Integer[])action.get((Integer)firstOccurrence.get(right[0])))[right.length == 1 ? 0 : Integer.valueOf(right[1])];
            int U = ((Integer[])action.get(R))[1];
            tempPropagator[0][R][L] = true;
            tempPropagator[0][((Integer[])action.get((int)R))[6].intValue()][((Integer[])action.get((int)L))[6].intValue()] = true;
            tempPropagator[0][((Integer[])action.get((int)L))[4].intValue()][((Integer[])action.get((int)R))[4].intValue()] = true;
            tempPropagator[0][((Integer[])action.get((int)L))[2].intValue()][((Integer[])action.get((int)R))[2].intValue()] = true;
            tempPropagator[1][U][D] = true;
            tempPropagator[1][((Integer[])action.get((int)D))[6].intValue()][((Integer[])action.get((int)U))[6].intValue()] = true;
            tempPropagator[1][((Integer[])action.get((int)U))[4].intValue()][((Integer[])action.get((int)D))[4].intValue()] = true;
            tempPropagator[1][((Integer[])action.get((int)D))[2].intValue()][((Integer[])action.get((int)U))[2].intValue()] = true;
        }
        for (int t2 = 0; t2 < this.T; ++t2) {
            for (int t1 = 0; t1 < this.T; ++t1) {
                tempPropagator[2][t2][t1] = tempPropagator[0][t1][t2];
                tempPropagator[3][t2][t1] = tempPropagator[1][t1][t2];
            }
        }
        ArrayList sparsePropagator = new ArrayList();
        for (d = 0; d < 4; ++d) {
            sparsePropagator.add(d, new ArrayList());
            for (int t = 0; t < this.T; ++t) {
                ((ArrayList)sparsePropagator.get(d)).add(t, new ArrayList());
            }
        }
        for (d = 0; d < 4; ++d) {
            for (int t1 = 0; t1 < this.T; ++t1) {
                ArrayList sp = (ArrayList)((ArrayList)sparsePropagator.get(d)).get(t1);
                boolean[] tp = tempPropagator[d][t1];
                for (int t2 = 0; t2 < this.T; ++t2) {
                    if (!tp[t2]) continue;
                    sp.add(t2);
                }
                int ST = sp.size();
                this.propagator[d][t1] = new int[ST];
                for (int st = 0; st < ST; ++st) {
                    this.propagator[d][t1][st] = (Integer)sp.get(st);
                }
            }
        }
    }

    @Override
    protected boolean onBoundary(int x, int y) {
        return !this.periodic && (x < 0 || y < 0 || x >= this.FMX || y >= this.FMY);
    }

    public String textOutput() {
        StringBuilder result = new StringBuilder();
        for (int y = 0; y < this.FMY; ++y) {
            for (int x = 0; x < this.FMX; ++x) {
                result.append(String.format("{%s}, ", this.tilenames.get(this.observed[x + y * this.FMX])));
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public BufferedImage graphics() {
        BufferedImage result = new BufferedImage(this.FMX * this.tilesize, this.FMY * this.tilesize, 1);
        if (this.observed != null) {
            for (int x = 0; x < this.FMX; ++x) {
                for (int y = 0; y < this.FMY; ++y) {
                    Color[] tile = this.tiles.get(this.observed[x + y * this.FMX]);
                    for (int yt = 0; yt < this.tilesize; ++yt) {
                        for (int xt = 0; xt < this.tilesize; ++xt) {
                            Color c = tile[xt + yt * this.tilesize];
                            result.setRGB(x * this.tilesize + xt, y * this.tilesize + yt, c.getRGB());
                        }
                    }
                }
            }
        } else {
            for (int x = 0; x < this.FMX; ++x) {
                for (int y = 0; y < this.FMY; ++y) {
                    boolean[] a = this.wave[x + y * this.FMX];
                    int amount = IntStream.range(0, a.length).map(idx -> a[idx] ? 1 : 0).sum();
                    double lambda = 1.0 / IntStream.range(0, this.T).filter(idx -> a[idx]).mapToDouble(idx -> this.weights[idx]).sum();
                    for (int yt = 0; yt < this.tilesize; ++yt) {
                        for (int xt = 0; xt < this.tilesize; ++xt) {
                            if (this.black && amount == this.T) {
                                result.setRGB(x * this.tilesize + xt, y * this.tilesize * yt, -16777216);
                                continue;
                            }
                            double r = 0.0;
                            double g = 0.0;
                            double b = 0.0;
                            for (int t = 0; t < this.T; ++t) {
                                if (!a[t]) continue;
                                Color c = this.tiles.get(t)[xt + yt * this.tilesize];
                                r += (double)c.getRed() * this.weights[t] * lambda;
                                g += (double)c.getGreen() * this.weights[t] * lambda;
                                b += (double)c.getBlue() * this.weights[t] * lambda;
                            }
                            Color newColor = new Color((int)r, (int)g, (int)b);
                            result.setRGB(x * this.tilesize + xt, y * this.tilesize + yt, newColor.getRGB());
                        }
                    }
                }
            }
        }
        return result;
    }
}

