/*
 * Decompiled with CFR 0.152.
 */
package com.github.sjcasey21.wavefunctioncollapse;

import com.github.sjcasey21.wavefunctioncollapse.StackEntry;
import java.awt.image.BufferedImage;
import java.util.Random;

abstract class Model {
    protected boolean[][] wave;
    protected int[][][] propagator;
    int[][][] compatible;
    protected int[] observed;
    StackEntry[] stack;
    int stacksize;
    protected Random random;
    protected int FMX;
    protected int FMY;
    protected int T;
    protected boolean periodic;
    protected Double[] weights;
    double[] weightLogWeights;
    int[] sumsOfOnes;
    double sumOfWeights;
    double sumOfWeightLogWeights;
    double startingEntropy;
    double[] sumsOfWeights;
    double[] sumsOfWeightLogWeights;
    double[] entropies;
    protected static int[] DX = new int[]{-1, 0, 1, 0};
    protected static int[] DY = new int[]{0, 1, 0, -1};
    static int[] oppposite = new int[]{2, 3, 0, 1};

    protected Model(int width, int height) {
        this.FMX = width;
        this.FMY = height;
    }

    protected abstract boolean onBoundary(int var1, int var2);

    public abstract BufferedImage graphics();

    static int randomIndice(double[] arr, double r) {
        int j;
        double sum = 0.0;
        for (j = 0; j < arr.length; ++j) {
            sum += arr[j];
        }
        j = 0;
        while (j < arr.length) {
            int n = j++;
            arr[n] = arr[n] / sum;
        }
        double x = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            if (!(r <= (x += arr[i]))) continue;
            return i;
        }
        return 0;
    }

    public static long toPower(int a, int n) {
        long product = 1L;
        for (int i = 0; i < n; ++i) {
            product *= (long)a;
        }
        return product;
    }

    void init() {
        this.wave = new boolean[this.FMX * this.FMY][];
        this.compatible = new int[this.wave.length][][];
        for (int i = 0; i < this.wave.length; ++i) {
            this.wave[i] = new boolean[this.T];
            this.compatible[i] = new int[this.T][];
            for (int t = 0; t < this.T; ++t) {
                this.compatible[i][t] = new int[4];
            }
        }
        this.weightLogWeights = new double[this.T];
        this.sumOfWeights = 0.0;
        this.sumOfWeightLogWeights = 0.0;
        for (int t = 0; t < this.T; ++t) {
            this.weightLogWeights[t] = this.weights[t] * Math.log(this.weights[t]);
            this.sumOfWeights += this.weights[t].doubleValue();
            this.sumOfWeightLogWeights += this.weightLogWeights[t];
        }
        this.startingEntropy = Math.log(this.sumOfWeights) - this.sumOfWeightLogWeights / this.sumOfWeights;
        this.sumsOfOnes = new int[this.FMX * this.FMY];
        this.sumsOfWeights = new double[this.FMX * this.FMY];
        this.sumsOfWeightLogWeights = new double[this.FMX * this.FMY];
        this.entropies = new double[this.FMX * this.FMY];
        this.stack = new StackEntry[this.wave.length * this.T];
        this.stacksize = 0;
    }

    Boolean observe() {
        int t;
        int i;
        double min = 1000.0;
        int argmin = -1;
        for (i = 0; i < this.wave.length; ++i) {
            double noise;
            if (this.onBoundary(i % this.FMX, i / this.FMX)) continue;
            int amount = this.sumsOfOnes[i];
            if (amount == 0) {
                return false;
            }
            double entropy = this.entropies[i];
            if (amount <= 1 || !(entropy <= min) || !(entropy + (noise = 1.0E-6 * this.random.nextDouble()) < min)) continue;
            min = entropy + noise;
            argmin = i;
        }
        if (argmin == -1) {
            this.observed = new int[this.FMX * this.FMY];
            block1: for (i = 0; i < this.wave.length; ++i) {
                for (t = 0; t < this.T; ++t) {
                    if (!this.wave[i][t]) continue;
                    this.observed[i] = t;
                    continue block1;
                }
            }
            return true;
        }
        double[] distribution = new double[this.T];
        for (t = 0; t < this.T; ++t) {
            distribution[t] = this.wave[argmin][t] ? this.weights[t] : 0.0;
        }
        int r = Model.randomIndice(distribution, this.random.nextDouble());
        boolean[] w = this.wave[argmin];
        for (int t2 = 0; t2 < this.T; ++t2) {
            if (w[t2] == (t2 == r)) continue;
            this.ban(argmin, t2);
        }
        return null;
    }

    protected void ban(int i, int t) {
        this.wave[i][t] = false;
        int[] comp = this.compatible[i][t];
        for (int d = 0; d < 4; ++d) {
            comp[d] = 0;
        }
        this.stack[this.stacksize] = new StackEntry(i, t);
        ++this.stacksize;
        int n = i;
        this.sumsOfOnes[n] = this.sumsOfOnes[n] - 1;
        int n2 = i;
        this.sumsOfWeights[n2] = this.sumsOfWeights[n2] - this.weights[t];
        int n3 = i;
        this.sumsOfWeightLogWeights[n3] = this.sumsOfWeightLogWeights[n3] - this.weightLogWeights[t];
        double sum = this.sumsOfWeights[i];
        this.entropies[i] = Math.log(sum) - this.sumsOfWeightLogWeights[i] / sum;
    }

    protected void propagate() {
        while (this.stacksize > 0) {
            StackEntry e1 = this.stack[this.stacksize - 1];
            --this.stacksize;
            int i1 = e1.getFirst();
            int x1 = i1 % this.FMX;
            int y1 = i1 / this.FMX;
            for (int d = 0; d < 4; ++d) {
                int dx = DX[d];
                int x2 = x1 + dx;
                int dy = DY[d];
                int y2 = y1 + dy;
                if (this.onBoundary(x2, y2)) continue;
                if (x2 < 0) {
                    x2 += this.FMX;
                } else if (x2 >= this.FMX) {
                    x2 -= this.FMX;
                }
                if (y2 < 0) {
                    y2 += this.FMY;
                } else if (y2 >= this.FMY) {
                    y2 -= this.FMY;
                }
                int i2 = x2 + y2 * this.FMX;
                int[] p = this.propagator[d][e1.getSecond()];
                int[][] compat = this.compatible[i2];
                for (int l = 0; l < p.length; ++l) {
                    int t2 = p[l];
                    int[] comp = compat[t2];
                    int n = d;
                    comp[n] = comp[n] - 1;
                    if (comp[d] != 0) continue;
                    this.ban(i2, t2);
                }
            }
        }
    }

    public boolean run(int seed, int limit) {
        if (this.wave == null) {
            this.init();
        }
        this.Clear();
        this.random = new Random(seed);
        for (int l = 0; l < limit || limit == 0; ++l) {
            Boolean result = this.observe();
            if (result != null) {
                return result;
            }
            this.propagate();
        }
        return true;
    }

    protected void Clear() {
        for (int i = 0; i < this.wave.length; ++i) {
            for (int t = 0; t < this.T; ++t) {
                this.wave[i][t] = true;
                for (int d = 0; d < 4; ++d) {
                    this.compatible[i][t][d] = this.propagator[oppposite[d]][t].length;
                }
            }
            this.sumsOfOnes[i] = this.weights.length;
            this.sumsOfWeights[i] = this.sumOfWeights;
            this.sumsOfWeightLogWeights[i] = this.sumOfWeightLogWeights;
            this.entropies[i] = this.startingEntropy;
        }
    }
}

