/*
 * Decompiled with CFR 0.152.
 */
package com.github.sjcasey21.wavefunctioncollapse;

import com.github.sjcasey21.wavefunctioncollapse.Model;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class OverlappingModel
extends Model {
    int N;
    Integer[][] patterns;
    int ground;
    List<Color> colors;

    public OverlappingModel(BufferedImage data, int N, int width, int height, boolean periodicInput, boolean periodicOutput, int symmetry, int ground) {
        super(width, height);
        this.N = N;
        this.periodic = periodicOutput;
        int SMX = data.getWidth();
        int SMY = data.getHeight();
        Integer[][] sample = new Integer[SMX][SMY];
        this.colors = new ArrayList<Color>();
        for (int y2 = 0; y2 < SMY; ++y2) {
            for (int x2 = 0; x2 < SMX; ++x2) {
                Color color = new Color(data.getRGB(x2, y2));
                int i = 0;
                for (Color c : this.colors) {
                    if (c.equals(color)) break;
                    ++i;
                }
                if (i == this.colors.size()) {
                    this.colors.add(color);
                }
                sample[x2][y2] = i;
            }
        }
        int C = this.colors.size();
        long W = OverlappingModel.toPower(C, this.N * this.N);
        Function<BiFunction, Integer[]> pattern = f -> {
            Integer[] result = new Integer[this.N * this.N];
            for (int y = 0; y < this.N; ++y) {
                for (int x = 0; x < this.N; ++x) {
                    result[x + y * this.N] = (Integer)f.apply(x, y);
                }
            }
            return result;
        };
        BiFunction<Integer, Integer, Integer[]> patternFromSample = (x, y) -> (Integer[])pattern.apply((dx, dy) -> sample[(x + dx) % SMX][(y + dy) % SMY]);
        Function<Integer[], Integer[]> rotate = p -> (Integer[])pattern.apply((x, y) -> p[this.N - 1 - y + x * this.N]);
        Function<Integer[], Integer[]> reflect = p -> (Integer[])pattern.apply((x, y) -> p[this.N - 1 - x + y * this.N]);
        Function<Integer[], Long> index = p -> {
            long result = 0L;
            long power = 1L;
            for (int i = 0; i < ((Integer[])p).length; ++i) {
                result += (long)p[((Integer[])p).length - 1 - i].intValue() * power;
                power *= (long)C;
            }
            return result;
        };
        Function<Long, Integer[]> patternFromIndex = ind -> {
            long residue = ind;
            long power = W;
            Integer[] result = new Integer[this.N * this.N];
            for (int i = 0; i < result.length; ++i) {
                power /= (long)C;
                int count = 0;
                while (residue >= power) {
                    residue -= power;
                    ++count;
                }
                result[i] = count;
            }
            return result;
        };
        HashMap<Long, Integer> weights = new HashMap<Long, Integer>();
        ArrayList<Long> ordering = new ArrayList<Long>();
        for (int y3 = 0; y3 < (periodicInput ? SMY : SMY - N + 1); ++y3) {
            for (int x3 = 0; x3 < (periodicInput ? SMX : SMX - this.N + 1); ++x3) {
                Integer[][] ps;
                ps = new Integer[][]{patternFromSample.apply(x3, y3), reflect.apply(ps[0]), rotate.apply(ps[0]), reflect.apply(ps[2]), rotate.apply(ps[2]), reflect.apply(ps[4]), rotate.apply(ps[4]), reflect.apply(ps[6])};
                for (int k = 0; k < symmetry; ++k) {
                    long ind2 = index.apply(ps[k]);
                    if (weights.containsKey(ind2)) {
                        weights.put(ind2, (Integer)weights.get(ind2) + 1);
                        continue;
                    }
                    weights.put(ind2, 1);
                    ordering.add(ind2);
                }
            }
        }
        this.T = weights.size();
        this.ground = (ground + this.T) % this.T;
        this.patterns = new Integer[this.T][];
        this.weights = new Double[this.T];
        int counter = 0;
        Iterator x3 = ordering.iterator();
        while (x3.hasNext()) {
            long w = (Long)x3.next();
            this.patterns[counter] = patternFromIndex.apply(w);
            this.weights[counter] = (double)((Integer)weights.get(w));
            ++counter;
        }
        Agrees<Integer[], Integer[], Integer, Integer, Boolean> agrees = (p1, p2, dx, dy) -> {
            int xmin = dx < 0 ? 0 : dx;
            int xmax = dx < 0 ? dx + N : N;
            int ymin = dy < 0 ? 0 : dy;
            int ymax = dy < 0 ? dy + N : N;
            for (int y = ymin; y < ymax; ++y) {
                for (int x = xmin; x < xmax; ++x) {
                    if (p1[x + this.N * y] == p2[x - dx + this.N * (y - dy)]) continue;
                    return false;
                }
            }
            return true;
        };
        this.propagator = new int[4][][];
        for (int d = 0; d < 4; ++d) {
            this.propagator[d] = new int[this.T][];
            for (int t = 0; t < this.T; ++t) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int t2 = 0; t2 < this.T; ++t2) {
                    if (!agrees.apply(this.patterns[t], this.patterns[t2], Model.DX[d], Model.DY[d]).booleanValue()) continue;
                    list.add(t2);
                }
                this.propagator[d][t] = new int[list.size()];
                for (int c = 0; c < list.size(); ++c) {
                    this.propagator[d][t][c] = (Integer)list.get(c);
                }
            }
        }
    }

    @Override
    protected boolean onBoundary(int x, int y) {
        return !this.periodic && (x + this.N > this.FMX || y + this.N > this.FMY || x < 0 || y < 0);
    }

    @Override
    public BufferedImage graphics() {
        BufferedImage result = new BufferedImage(this.FMX, this.FMY, 1);
        if (this.observed != null) {
            for (int y = 0; y < this.FMY; ++y) {
                int dy = y < this.FMY - this.N + 1 ? 0 : this.N - 1;
                for (int x = 0; x < this.FMX; ++x) {
                    int dx = x < this.FMX - this.N + 1 ? 0 : this.N - 1;
                    Color c = this.colors.get(this.patterns[this.observed[x - dx + (y - dy) * this.FMX]][dx + dy * this.N]);
                    result.setRGB(x, y, c.getRGB());
                }
            }
        } else {
            for (int i = 0; i < this.wave.length; ++i) {
                int contributors = 0;
                int r = 0;
                int g = 0;
                int b = 0;
                int x = i % this.FMX;
                int y = i / this.FMX;
                for (int dy = 0; dy < this.N; ++dy) {
                    for (int dx = 0; dx < this.N; ++dx) {
                        int sy;
                        int sx = x - dx;
                        if (sx < 0) {
                            sx += this.FMX;
                        }
                        if ((sy = y - dy) < 0) {
                            sy += this.FMY;
                        }
                        int s = sx + sy * this.FMX;
                        if (this.onBoundary(sx, sy)) continue;
                        for (int t = 0; t < this.T; ++t) {
                            if (!this.wave[s][t]) continue;
                            ++contributors;
                            Color color = this.colors.get(this.patterns[t][dx + dy * this.N]);
                            r += color.getRed();
                            g += color.getGreen();
                            b += color.getBlue();
                        }
                    }
                }
                Color c = new Color(r / contributors, g / contributors, b / contributors);
                result.setRGB(x, y, c.getRGB());
            }
        }
        return result;
    }

    @Override
    protected void Clear() {
        super.Clear();
        if (this.ground != 0) {
            for (int x = 0; x < this.FMX; ++x) {
                for (int t = 0; t < this.T; ++t) {
                    if (t == this.ground) continue;
                    this.ban(x + (this.FMY - 1) * this.FMX, t);
                }
                for (int y = 0; y < this.FMY - 1; ++y) {
                    this.ban(x + y * this.FMX, this.ground);
                }
            }
            this.propagate();
        }
    }

    @FunctionalInterface
    static interface Agrees<One, Two, Three, Four, Five> {
        public Five apply(One var1, Two var2, Three var3, Four var4);
    }
}

