/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.jdbc;

import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SpartaNamedParameterJdbcTemplate
extends NamedParameterJdbcTemplate {
    public SpartaNamedParameterJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public SpartaNamedParameterJdbcTemplate(JdbcOperations jdbcOperations) {
        super(jdbcOperations);
    }

    public <T> Optional<T> queryForOptionalObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, paramSource, rowMapper);
            result = Optional.of(obj);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, paramMap, rowMapper);
            result = Optional.of(obj);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, paramSource, requiredType);
            result = Optional.of(obj);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }

    public <T> Optional<T> queryForOptionalObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException {
        Optional<Object> result;
        try {
            Object obj = super.queryForObject(sql, paramMap, requiredType);
            result = Optional.of(obj);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            result = Optional.empty();
        }
        return result;
    }
}

