/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Automount;
import de.thjom.java.systemd.BusName;
import de.thjom.java.systemd.Device;
import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Mount;
import de.thjom.java.systemd.Path;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Scope;
import de.thjom.java.systemd.Service;
import de.thjom.java.systemd.Slice;
import de.thjom.java.systemd.Snapshot;
import de.thjom.java.systemd.Socket;
import de.thjom.java.systemd.Swap;
import de.thjom.java.systemd.Target;
import de.thjom.java.systemd.Timer;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.ManagerInterface;
import de.thjom.java.systemd.types.UnitFileType;
import de.thjom.java.systemd.types.UnitType;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;

public class Manager
extends InterfaceAdapter {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Manager";
    private boolean subscribed;

    private Manager(DBusConnection dbus, ManagerInterface iface) throws DBusException {
        super(dbus, iface);
        this.properties = Properties.create(dbus, "/org/freedesktop/systemd1", SERVICE_NAME);
    }

    static Manager create(DBusConnection dbus) throws DBusException {
        ManagerInterface iface = (ManagerInterface)dbus.getRemoteObject("org.freedesktop.systemd1", "/org/freedesktop/systemd1", ManagerInterface.class);
        return new Manager(dbus, iface);
    }

    @Override
    public ManagerInterface getInterface() {
        return (ManagerInterface)super.getInterface();
    }

    public String introspect() throws DBusException {
        DBus.Introspectable intro = (DBus.Introspectable)this.dbus.getRemoteObject("org.freedesktop.systemd1", "/org/freedesktop/systemd1", DBus.Introspectable.class);
        return intro.Introspect();
    }

    public void cancelJob(long id) {
        this.getInterface().cancelJob(id);
    }

    public void clearJobs() {
        this.getInterface().clearJobs();
    }

    public String dump() {
        return this.getInterface().dump();
    }

    public String getDefaultTarget() {
        return this.getInterface().getDefaultTarget();
    }

    public void halt() {
        this.getInterface().halt();
    }

    public void kExec() {
        this.getInterface().kExec();
    }

    public void killUnit(String name, Unit.Who who, int signal) {
        this.killUnit(name, who.getValue(), signal);
    }

    public void killUnit(String name, String who, int signal) {
        this.getInterface().killUnit(name, who, signal);
    }

    public List<UnitFileType> listUnitFiles() {
        return this.getInterface().listUnitFiles();
    }

    public List<UnitType> listUnits() {
        return this.getInterface().listUnits();
    }

    public void powerOff() {
        this.getInterface().powerOff();
    }

    public void reboot() {
        this.getInterface().reboot();
    }

    public void reexecute() {
        this.getInterface().reexecute();
    }

    public void refUnit(String name) {
        this.getInterface().refUnit(name);
    }

    public void reload() {
        this.getInterface().reload();
    }

    public org.freedesktop.dbus.Path reloadOrRestartUnit(String name, Unit.Mode mode) {
        return this.reloadOrRestartUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path reloadOrRestartUnit(String name, String mode) {
        return this.getInterface().reloadOrRestartUnit(name, mode);
    }

    public org.freedesktop.dbus.Path reloadOrTryRestartUnit(String name, Unit.Mode mode) {
        return this.reloadOrTryRestartUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path reloadOrTryRestartUnit(String name, String mode) {
        return this.getInterface().reloadOrTryRestartUnit(name, mode);
    }

    public org.freedesktop.dbus.Path reloadUnit(String name, Unit.Mode mode) {
        return this.reloadUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path reloadUnit(String name, String mode) {
        return this.getInterface().reloadUnit(name, mode);
    }

    public void resetFailedUnit(String name) {
        this.getInterface().resetFailedUnit(name);
    }

    public org.freedesktop.dbus.Path restartUnit(String name, Unit.Mode mode) {
        return this.restartUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path restartUnit(String name, String mode) {
        return this.getInterface().restartUnit(name, mode);
    }

    public org.freedesktop.dbus.Path startUnit(String name, Unit.Mode mode) {
        return this.startUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path startUnit(String name, String mode) {
        return this.getInterface().startUnit(name, mode);
    }

    public org.freedesktop.dbus.Path stopUnit(String name, Unit.Mode mode) {
        return this.stopUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path stopUnit(String name, String mode) {
        return this.getInterface().stopUnit(name, mode);
    }

    public org.freedesktop.dbus.Path tryRestartUnit(String name, Unit.Mode mode) {
        return this.tryRestartUnit(name, mode.getValue());
    }

    public org.freedesktop.dbus.Path tryRestartUnit(String name, String mode) {
        return this.getInterface().tryRestartUnit(name, mode);
    }

    public void unrefUnit(String name) {
        this.getInterface().unrefUnit(name);
    }

    public synchronized void subscribe() {
        if (!this.subscribed) {
            this.getInterface().subscribe();
            this.subscribed = true;
        }
    }

    public synchronized void unsubscribe() {
        if (this.subscribed) {
            this.getInterface().unsubscribe();
            this.subscribed = false;
        }
    }

    public Automount getAutomount(String name) throws DBusException {
        return Automount.create(this, name);
    }

    public BusName getBusName(String name) throws DBusException {
        return BusName.create(this, name);
    }

    public Device getDevice(String name) throws DBusException {
        return Device.create(this, name);
    }

    public Mount getMount(String name) throws DBusException {
        return Mount.create(this, name);
    }

    public Path getPath(String name) throws DBusException {
        return Path.create(this, name);
    }

    public Scope getScope(String name) throws DBusException {
        return Scope.create(this, name);
    }

    public Service getService(String name) throws DBusException {
        return Service.create(this, name);
    }

    public Slice getSlice(String name) throws DBusException {
        return Slice.create(this, name);
    }

    public Snapshot getSnapshot(String name) throws DBusException {
        return Snapshot.create(this, name);
    }

    public Socket getSocket(String name) throws DBusException {
        return Socket.create(this, name);
    }

    public Swap getSwap(String name) throws DBusException {
        return Swap.create(this, name);
    }

    public Target getTarget(String name) throws DBusException {
        return Target.create(this, name);
    }

    public Timer getTimer(String name) throws DBusException {
        return Timer.create(this, name);
    }

    public Unit getUnit(String fullName) throws DBusException {
        Unit unit;
        String suffix;
        switch (suffix = fullName.substring(fullName.lastIndexOf(46))) {
            case ".automount": {
                unit = this.getAutomount(fullName);
                break;
            }
            case ".busname": {
                unit = this.getBusName(fullName);
                break;
            }
            case ".device": {
                unit = this.getDevice(fullName);
                break;
            }
            case ".mount": {
                unit = this.getMount(fullName);
                break;
            }
            case ".path": {
                unit = this.getPath(fullName);
                break;
            }
            case ".scope": {
                unit = this.getScope(fullName);
                break;
            }
            case ".service": {
                unit = this.getService(fullName);
                break;
            }
            case ".slice": {
                unit = this.getSlice(fullName);
                break;
            }
            case ".snapshot": {
                unit = this.getSnapshot(fullName);
                break;
            }
            case ".socket": {
                unit = this.getSocket(fullName);
                break;
            }
            case ".swap": {
                unit = this.getSwap(fullName);
                break;
            }
            case ".target": {
                unit = this.getTarget(fullName);
                break;
            }
            case ".timer": {
                unit = this.getTimer(fullName);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unable to determine unit type by name suffix from '%s'", fullName));
            }
        }
        return unit;
    }

    public String getArchitecture() {
        return this.properties.getString("Architecture");
    }

    public boolean isConfirmSpawn() {
        return this.properties.getBoolean("ConfirmSpawn");
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public boolean isDefaultBlockIOAccounting() {
        return this.properties.getBoolean("DefaultBlockIOAccounting");
    }

    public boolean isDefaultCPUAccounting() {
        return this.properties.getBoolean("DefaultCPUAccounting");
    }

    public BigInteger getDefaultLimitAS() {
        return this.properties.getBigInteger("DefaultLimitAS");
    }

    public BigInteger getDefaultLimitASSoft() {
        return this.properties.getBigInteger("DefaultLimitASSoft");
    }

    public BigInteger getDefaultLimitCORE() {
        return this.properties.getBigInteger("DefaultLimitCORE");
    }

    public BigInteger getDefaultLimitCORESoft() {
        return this.properties.getBigInteger("DefaultLimitCORESoft");
    }

    public BigInteger getDefaultLimitCPU() {
        return this.properties.getBigInteger("DefaultLimitCPU");
    }

    public BigInteger getDefaultLimitCPUSoft() {
        return this.properties.getBigInteger("DefaultLimitCPUSoft");
    }

    public BigInteger getDefaultLimitDATA() {
        return this.properties.getBigInteger("DefaultLimitDATA");
    }

    public BigInteger getDefaultLimitDATASoft() {
        return this.properties.getBigInteger("DefaultLimitDATASoft");
    }

    public BigInteger getDefaultLimitFSIZE() {
        return this.properties.getBigInteger("DefaultLimitFSIZE");
    }

    public BigInteger getDefaultLimitFSIZESoft() {
        return this.properties.getBigInteger("DefaultLimitFSIZESoft");
    }

    public BigInteger getDefaultLimitLOCKS() {
        return this.properties.getBigInteger("DefaultLimitLOCKS");
    }

    public BigInteger getDefaultLimitLOCKSSoft() {
        return this.properties.getBigInteger("DefaultLimitLOCKSSoft");
    }

    public BigInteger getDefaultLimitMEMLOCK() {
        return this.properties.getBigInteger("DefaultLimitMEMLOCK");
    }

    public BigInteger getDefaultLimitMEMLOCKSoft() {
        return this.properties.getBigInteger("DefaultLimitMEMLOCKSoft");
    }

    public BigInteger getDefaultLimitMSGQUEUE() {
        return this.properties.getBigInteger("DefaultLimitMSGQUEUE");
    }

    public BigInteger getDefaultLimitMSGQUEUESoft() {
        return this.properties.getBigInteger("DefaultLimitMSGQUEUESoft");
    }

    public BigInteger getDefaultLimitNICE() {
        return this.properties.getBigInteger("DefaultLimitNICE");
    }

    public BigInteger getDefaultLimitNICESoft() {
        return this.properties.getBigInteger("DefaultLimitNICESoft");
    }

    public BigInteger getDefaultLimitNOFILE() {
        return this.properties.getBigInteger("DefaultLimitNOFILE");
    }

    public BigInteger getDefaultLimitNOFILESoft() {
        return this.properties.getBigInteger("DefaultLimitNOFILESoft");
    }

    public BigInteger getDefaultLimitNPROC() {
        return this.properties.getBigInteger("DefaultLimitNPROC");
    }

    public BigInteger getDefaultLimitNPROCSoft() {
        return this.properties.getBigInteger("DefaultLimitNPROCSoft");
    }

    public BigInteger getDefaultLimitRSS() {
        return this.properties.getBigInteger("DefaultLimitRSS");
    }

    public BigInteger getDefaultLimitRSSSoft() {
        return this.properties.getBigInteger("DefaultLimitRSSSoft");
    }

    public BigInteger getDefaultLimitRTPRIO() {
        return this.properties.getBigInteger("DefaultLimitRTPRIO");
    }

    public BigInteger getDefaultLimitRTPRIOSoft() {
        return this.properties.getBigInteger("DefaultLimitRTPRIOSoft");
    }

    public BigInteger getDefaultLimitRTTIME() {
        return this.properties.getBigInteger("DefaultLimitRTTIME");
    }

    public BigInteger getDefaultLimitRTTIMESoft() {
        return this.properties.getBigInteger("DefaultLimitRTTIMESoft");
    }

    public BigInteger getDefaultLimitSIGPENDING() {
        return this.properties.getBigInteger("DefaultLimitSIGPENDING");
    }

    public BigInteger getDefaultLimitSIGPENDINGSoft() {
        return this.properties.getBigInteger("DefaultLimitSIGPENDINGSoft");
    }

    public BigInteger getDefaultLimitSTACK() {
        return this.properties.getBigInteger("DefaultLimitSTACK");
    }

    public BigInteger getDefaultLimitSTACKSoft() {
        return this.properties.getBigInteger("DefaultLimitSTACKSoft");
    }

    public boolean isDefaultMemoryAccounting() {
        return this.properties.getBoolean("DefaultMemoryAccounting");
    }

    public BigInteger getDefaultRestartUSec() {
        return this.properties.getBigInteger("DefaultRestartUSec");
    }

    public String getDefaultStandardError() {
        return this.properties.getString("DefaultStandardError");
    }

    public String getDefaultStandardOutput() {
        return this.properties.getString("DefaultStandardOutput");
    }

    public long getDefaultStartLimitBurst() {
        return this.properties.getLong("DefaultStartLimitBurst");
    }

    public long getDefaultStartLimitIntervalSec() {
        return this.properties.getLong("DefaultStartLimitIntervalSec");
    }

    public boolean isDefaultTasksAccounting() {
        return this.properties.getBoolean("DefaultTasksAccounting");
    }

    public BigInteger getDefaultTasksMax() {
        return this.properties.getBigInteger("DefaultTasksMax");
    }

    public BigInteger getDefaultTimeoutStartUSec() {
        return this.properties.getBigInteger("DefaultTimeoutStartUSec");
    }

    public BigInteger getDefaultTimeoutStopUSec() {
        return this.properties.getBigInteger("DefaultTimeoutStopUSec");
    }

    public BigInteger getDefaultTimerAccuracyUSec() {
        return this.properties.getBigInteger("DefaultTimerAccuracyUSec");
    }

    public Vector<String> getEnvironment() {
        return this.properties.getVector("Environment");
    }

    public byte getExitCode() {
        return this.properties.getByte("ExitCode");
    }

    public String getFeatures() {
        return this.properties.getString("Features");
    }

    public long getFinishTimestamp() {
        return this.properties.getLong("FinishTimestamp");
    }

    public long getFinishTimestampMonotonic() {
        return this.properties.getLong("FinishTimestampMonotonic");
    }

    public long getFirmwareTimestamp() {
        return this.properties.getLong("FirmwareTimestamp");
    }

    public long getFirmwareTimestampMonotonic() {
        return this.properties.getLong("FirmwareTimestampMonotonic");
    }

    public long getGeneratorsFinishTimestamp() {
        return this.properties.getLong("GeneratorsFinishTimestamp");
    }

    public long getGeneratorsFinishTimestampMonotonic() {
        return this.properties.getLong("GeneratorsFinishTimestampMonotonic");
    }

    public long getGeneratorsStartTimestamp() {
        return this.properties.getLong("GeneratorsStartTimestamp");
    }

    public long getGeneratorsStartTimestampMonotonic() {
        return this.properties.getLong("GeneratorsStartTimestampMonotonic");
    }

    public long getInitRDTimestamp() {
        return this.properties.getLong("InitRDTimestamp");
    }

    public long getInitRDTimestampMonotonic() {
        return this.properties.getLong("InitRDTimestampMonotonic");
    }

    public long getKernelTimestamp() {
        return this.properties.getLong("KernelTimestamp");
    }

    public long getKernelTimestampMonotonic() {
        return this.properties.getLong("KernelTimestampMonotonic");
    }

    public long getLoaderTimestamp() {
        return this.properties.getLong("LoaderTimestamp");
    }

    public long getLoaderTimestampMonotonic() {
        return this.properties.getLong("LoaderTimestampMonotonic");
    }

    public String getLogLevel() {
        return this.properties.getString("LogLevel");
    }

    public String getLogTarget() {
        return this.properties.getString("LogTarget");
    }

    public long getNFailedJobs() {
        return this.properties.getLong("NFailedJobs");
    }

    public long getNFailedUnits() {
        return this.properties.getLong("NFailedUnits");
    }

    public long getNInstalledJobs() {
        return this.properties.getLong("NInstalledJobs");
    }

    public long getNJobs() {
        return this.properties.getLong("NJobs");
    }

    public long getNNames() {
        return this.properties.getLong("NNames");
    }

    public double getProgress() {
        return this.properties.getDouble("Progress");
    }

    public BigInteger getRuntimeWatchdogUSec() {
        return this.properties.getBigInteger("RuntimeWatchdogUSec");
    }

    public long getSecurityFinishTimestamp() {
        return this.properties.getLong("SecurityFinishTimestamp");
    }

    public long getSecurityFinishTimestampMonotonic() {
        return this.properties.getLong("SecurityFinishTimestampMonotonic");
    }

    public long getSecurityStartTimestamp() {
        return this.properties.getLong("SecurityStartTimestamp");
    }

    public long getSecurityStartTimestampMonotonic() {
        return this.properties.getLong("SecurityStartTimestampMonotonic");
    }

    public boolean isShowStatus() {
        return this.properties.getBoolean("ShowStatus");
    }

    public BigInteger getShutdownWatchdogUSec() {
        return this.properties.getBigInteger("ShutdownWatchdogUSec");
    }

    public String getSystemState() {
        return this.properties.getString("SystemState");
    }

    public String getTainted() {
        return this.properties.getString("Tainted");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public Vector<String> getUnitPath() {
        return this.properties.getVector("UnitPath");
    }

    public long getUnitsLoadFinishTimestamp() {
        return this.properties.getLong("UnitsLoadFinishTimestamp");
    }

    public long getUnitsLoadFinishTimestampMonotonic() {
        return this.properties.getLong("UnitsLoadFinishTimestampMonotonic");
    }

    public long getUnitsLoadStartTimestamp() {
        return this.properties.getLong("UnitsLoadStartTimestamp");
    }

    public long getUnitsLoadStartTimestampMonotonic() {
        return this.properties.getLong("UnitsLoadStartTimestampMonotonic");
    }

    public long getUserspaceTimestamp() {
        return this.properties.getLong("UserspaceTimestamp");
    }

    public long getUserspaceTimestampMonotonic() {
        return this.properties.getLong("UserspaceTimestampMonotonic");
    }

    public String getVersion() {
        return this.properties.getString("Version");
    }

    public String getVirtualization() {
        return this.properties.getString("Virtualization");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ARCHITECTURE = "Architecture";
        public static final String CONFIRM_SPAWN = "ConfirmSpawn";
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String DEFAULT_BLOCK_IO_ACCOUNTING = "DefaultBlockIOAccounting";
        public static final String DEFAULT_CPU_ACCOUNTING = "DefaultCPUAccounting";
        public static final String DEFAULT_LIMIT_AS = "DefaultLimitAS";
        public static final String DEFAULT_LIMIT_AS_SOFT = "DefaultLimitASSoft";
        public static final String DEFAULT_LIMIT_CORE = "DefaultLimitCORE";
        public static final String DEFAULT_LIMIT_CORE_SOFT = "DefaultLimitCORESoft";
        public static final String DEFAULT_LIMIT_CPU = "DefaultLimitCPU";
        public static final String DEFAULT_LIMIT_CPU_SOFT = "DefaultLimitCPUSoft";
        public static final String DEFAULT_LIMIT_DATA = "DefaultLimitDATA";
        public static final String DEFAULT_LIMIT_DATA_SOFT = "DefaultLimitDATASoft";
        public static final String DEFAULT_LIMIT_FSIZE = "DefaultLimitFSIZE";
        public static final String DEFAULT_LIMIT_FSIZE_SOFT = "DefaultLimitFSIZESoft";
        public static final String DEFAULT_LIMIT_LOCKS = "DefaultLimitLOCKS";
        public static final String DEFAULT_LIMIT_LOCKS_SOFT = "DefaultLimitLOCKSSoft";
        public static final String DEFAULT_LIMIT_MEMLOCK = "DefaultLimitMEMLOCK";
        public static final String DEFAULT_LIMIT_MEMLOCK_SOFT = "DefaultLimitMEMLOCKSoft";
        public static final String DEFAULT_LIMIT_MSGQUEUE = "DefaultLimitMSGQUEUE";
        public static final String DEFAULT_LIMIT_MSGQUEUE_SOFT = "DefaultLimitMSGQUEUESoft";
        public static final String DEFAULT_LIMIT_NICE = "DefaultLimitNICE";
        public static final String DEFAULT_LIMIT_NICE_SOFT = "DefaultLimitNICESoft";
        public static final String DEFAULT_LIMIT_NOFILE = "DefaultLimitNOFILE";
        public static final String DEFAULT_LIMIT_NOFILE_SOFT = "DefaultLimitNOFILESoft";
        public static final String DEFAULT_LIMIT_NPROC = "DefaultLimitNPROC";
        public static final String DEFAULT_LIMIT_NPROC_SOFT = "DefaultLimitNPROCSoft";
        public static final String DEFAULT_LIMIT_RSS = "DefaultLimitRSS";
        public static final String DEFAULT_LIMIT_RSS_SOFT = "DefaultLimitRSSSoft";
        public static final String DEFAULT_LIMIT_RTPRIO = "DefaultLimitRTPRIO";
        public static final String DEFAULT_LIMIT_RTPRIO_SOFT = "DefaultLimitRTPRIOSoft";
        public static final String DEFAULT_LIMIT_RTTIME = "DefaultLimitRTTIME";
        public static final String DEFAULT_LIMIT_RTTIME_SOFT = "DefaultLimitRTTIMESoft";
        public static final String DEFAULT_LIMIT_SIGPENDING = "DefaultLimitSIGPENDING";
        public static final String DEFAULT_LIMIT_SIGPENDING_SOFT = "DefaultLimitSIGPENDINGSoft";
        public static final String DEFAULT_LIMIT_STACK = "DefaultLimitSTACK";
        public static final String DEFAULT_LIMIT_STACK_SOFT = "DefaultLimitSTACKSoft";
        public static final String DEFAULT_MEMORY_ACCOUNTING = "DefaultMemoryAccounting";
        public static final String DEFAULT_RESTART_USEC = "DefaultRestartUSec";
        public static final String DEFAULT_STANDARD_ERROR = "DefaultStandardError";
        public static final String DEFAULT_STANDARD_OUTPUT = "DefaultStandardOutput";
        public static final String DEFAULT_START_LIMIT_BURST = "DefaultStartLimitBurst";
        public static final String DEFAULT_START_LIMIT_INTERVAL_SEC = "DefaultStartLimitIntervalSec";
        public static final String DEFAULT_TASKS_ACCOUNTING = "DefaultTasksAccounting";
        public static final String DEFAULT_TASKS_MAX = "DefaultTasksMax";
        public static final String DEFAULT_TIMEOUT_START_USEC = "DefaultTimeoutStartUSec";
        public static final String DEFAULT_TIMEOUT_STOP_USEC = "DefaultTimeoutStopUSec";
        public static final String DEFAULT_TIMER_ACCURACY_USEC = "DefaultTimerAccuracyUSec";
        public static final String ENVIRONMENT = "Environment";
        public static final String EXIT_CODE = "ExitCode";
        public static final String FEATURES = "Features";
        public static final String FINISH_TIMESTAMP = "FinishTimestamp";
        public static final String FINISH_TIMESTAMP_MONOTONIC = "FinishTimestampMonotonic";
        public static final String FIRMWARE_TIMESTAMP = "FirmwareTimestamp";
        public static final String FIRMWARE_TIMESTAMP_MONOTONIC = "FirmwareTimestampMonotonic";
        public static final String GENERATORS_FINISH_TIMESTAMP = "GeneratorsFinishTimestamp";
        public static final String GENERATORS_FINISH_TIMESTAMP_MONOTONIC = "GeneratorsFinishTimestampMonotonic";
        public static final String GENERATORS_START_TIMESTAMP = "GeneratorsStartTimestamp";
        public static final String GENERATORS_START_TIMESTAMP_MONOTONIC = "GeneratorsStartTimestampMonotonic";
        public static final String INIT_RD_TIMESTAMP = "InitRDTimestamp";
        public static final String INIT_RD_TIMESTAMP_MONOTONIC = "InitRDTimestampMonotonic";
        public static final String KERNEL_TIMESTAMP = "KernelTimestamp";
        public static final String KERNEL_TIMESTAMP_MONOTONIC = "KernelTimestampMonotonic";
        public static final String LOADER_TIMESTAMP = "LoaderTimestamp";
        public static final String LOADER_TIMESTAMP_MONOTONIC = "LoaderTimestampMonotonic";
        public static final String LOG_LEVEL = "LogLevel";
        public static final String LOG_TARGET = "LogTarget";
        public static final String NFAILED_JOBS = "NFailedJobs";
        public static final String NFAILED_UNITS = "NFailedUnits";
        public static final String NINSTALLED_JOBS = "NInstalledJobs";
        public static final String NJOBS = "NJobs";
        public static final String NNAMES = "NNames";
        public static final String PROGRESS = "Progress";
        public static final String RUNTIME_WATCHDOG_USEC = "RuntimeWatchdogUSec";
        public static final String SECURITY_FINISH_TIMESTAMP = "SecurityFinishTimestamp";
        public static final String SECURITY_FINISH_TIMESTAMP_MONOTONIC = "SecurityFinishTimestampMonotonic";
        public static final String SECURITY_START_TIMESTAMP = "SecurityStartTimestamp";
        public static final String SECURITY_START_TIMESTAMP_MONOTONIC = "SecurityStartTimestampMonotonic";
        public static final String SHOW_STATUS = "ShowStatus";
        public static final String SHUTDOWN_WATCHDOG_USEC = "ShutdownWatchdogUSec";
        public static final String SYSTEM_STATE = "SystemState";
        public static final String TAINTED = "Tainted";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String UNIT_PATH = "UnitPath";
        public static final String UNITS_LOAD_FINISH_TIMESTAMP = "UnitsLoadFinishTimestamp";
        public static final String UNITS_LOAD_FINISH_TIMESTAMP_MONOTONIC = "UnitsLoadFinishTimestampMonotonic";
        public static final String UNITS_LOAD_START_TIMESTAMP = "UnitsLoadStartTimestamp";
        public static final String UNITS_LOAD_START_TIMESTAMP_MONOTONIC = "UnitsLoadStartTimestampMonotonic";
        public static final String USERSPACE_TIMESTAMP = "UserspaceTimestamp";
        public static final String USERSPACE_TIMESTAMP_MONOTONIC = "UserspaceTimestampMonotonic";
        public static final String VERSION = "Version";
        public static final String VIRTUALIZATION = "Virtualization";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

