/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.interfaces.PropertyInterface;
import java.math.BigInteger;
import java.util.Vector;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.UInt64;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;

public class Properties
extends InterfaceAdapter {
    public static final String SERVICE_NAME = "org.freedesktop.DBus.Properties";
    private final String serviceName;

    private Properties(DBusConnection dbus, PropertyInterface iface, String serviceName) {
        super(dbus, iface);
        this.serviceName = serviceName;
    }

    static Properties create(DBusConnection dbus, String objectPath, String serviceName) throws DBusException {
        PropertyInterface iface = (PropertyInterface)dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, PropertyInterface.class);
        return new Properties(dbus, iface, serviceName);
    }

    @Override
    public PropertyInterface getInterface() {
        return (PropertyInterface)super.getInterface();
    }

    @Override
    public Properties getProperties() {
        return this;
    }

    public Variant<?> getVariant(String propertyName) {
        return this.getInterface().getProperty(this.serviceName, propertyName);
    }

    public boolean getBoolean(String propertyName) {
        Boolean value = (Boolean)this.getVariant(propertyName).getValue();
        return value;
    }

    public byte getByte(String propertyName) {
        Byte value = (Byte)this.getVariant(propertyName).getValue();
        return value;
    }

    public short getShort(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.shortValue();
    }

    public int getInteger(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.intValue();
    }

    public long getLong(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.longValue();
    }

    public BigInteger getBigInteger(String propertyName) {
        UInt64 value = (UInt64)this.getVariant(propertyName).getValue();
        return value.value();
    }

    public double getDouble(String propertyName) {
        Number value = (Number)this.getVariant(propertyName).getValue();
        return value.doubleValue();
    }

    public String getString(String propertyName) {
        return String.valueOf(this.getVariant(propertyName).getValue());
    }

    public <T> Vector<T> getVector(String propertyName) {
        return (Vector)this.getVariant(propertyName).getValue();
    }
}

